<?php
/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	    http://docs.woothemes.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( $order ) : ?>

	<?php if ( $order->has_status( 'failed' ) ) : ?>

		<p class="woocommerce-thankyou-order-failed"><?php _e( 'Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'woocommerce' ); ?></p>

		<p class="woocommerce-thankyou-order-failed-actions">
			<a href="<?php echo esc_url( $order->get_checkout_payment_url() ); ?>" class="button pay"><?php _e( 'Pay', 'woocommerce' ) ?></a>
			<?php if ( is_user_logged_in() ) : ?>
				<a href="<?php echo esc_url( wc_get_page_permalink( 'myaccount' ) ); ?>" class="button pay"><?php _e( 'My Account', 'woocommerce' ); ?></a>
			<?php endif; ?>
		</p>

	<?php else : ?>
		<?php
			$thankyou_text = get_option('WOOBISNES_woo_thanks');
			$social_text = get_option('WOOBISNES_social_vk_text');
		?>
		<p style="font-size: 16px; margin-bottom: 30px;"><?php echo $thankyou_text; ?></p>

		<div class="clear"></div>

				<p style="font-size: 16px; text-align: center; margin-bottom: 15px;"><?php echo $social_text; ?></p>
				<div class="instagram"><iframe src="https://averin.pro/widget.php?l=businki_lentochki.by&style=1&width=100%&gallery=1&s=100&icc=3&icr=3&t=1&tt=Мы в Инстаграм&h=1&ttcolor=FFFFFF&th=c3c3c3&bw=f9f9f9&bscolor=000000&bs=fbee71&ts=Подписаться&ch=utf8" allowtransparency="true" frameborder="0" scrolling="no" style="border:none;overflow:hidden;width:100%; height: 515px" ></iframe></div>				
				<!-- VK Widget :: start -->	
				<div id="vk_groups" style="margin: 0 auto; text-align: center; max-width:100%;">
				
				<script type="text/javascript">
					VK.Widgets.Group("vk_groups", {mode: 0, width: "auto", height: "350", color1: 'FFFFFF', color2: '2B587A', color3: '5B7FA6'}, 82278952);
				</script>
				</div>				
				<!-- VK Widget :: end -->				

	<?php endif; ?>

<?php else : ?>

	<p class="woocommerce-thankyou-order-received"><?php echo apply_filters( 'woocommerce_thankyou_order_received_text', __( 'Thank you. Your order has been received.', 'woocommerce' ), null ); ?></p>

<?php endif; ?>
