<?php get_header(); ?>

<div class="units-row">
    <div class="unit-70 pull-right">
        <nav class="breadcrumb">
            <?php $filename = TEMPLATEPATH . '/breadcrumb.php'; if (file_exists($filename)) { include($filename); } ?>
        </nav>

        <section class="content" role="main">
            <?php if (have_posts()) : while (have_posts()) : the_post(); ?>

                <article class="article article-single">
                    <h1 class="article-title"><?php the_title(); ?></h1>
                    <div class="article-info">
                        Категория: <?php the_category('single'); //$cat = get_the_category(); echo $cat[0]->cat_name; ?>&nbsp;/&nbsp;
                        Дата: <?php the_time('j F Y'); ?>
                    </div>

                    <?php if(get_image_path($post->ID) != ''):?>
                        <div class="article-img">
                            <img src="<?php echo get_image_path($post->ID); ?>" alt=""<?php the_title(); ?>"/>
                        </div>
                    <?endif; ?>

                    <?php the_content('', FALSE, ''); ?>
                    <div class="clear"></div>
                </article>

            <?php endwhile; ?>
            <?php else: ?>
            <?php endif; ?>


            <div class="woocommerce-tabs" style="margin-top: 30px;">
                <div id="horizontalTab">
                    <ul class="resp-tabs-list">
                        <li>Комментарии</li>
                    </ul>

                    <div class="resp-tabs-container">
                        <div>
                            <?php comments_template( '', true ) ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <div class="unit-30 pull-left">
        <aside class="sidebar" role="complementary">
            <?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('Сайтбар сайта') ) : ?>
            <?php endif; ?>
        </aside>
    </div>

</div>
<?php get_footer(); ?>
















