<?php get_header(); ?>


    <div class="units-row">

        <div class="unit-70 pull-right">

            <nav class="breadcrumb">

                <?php $filename = TEMPLATEPATH . '/breadcrumb.php'; if (file_exists($filename)) { include($filename); } ?>

            </nav>



            <section class="content <?php if (is_search()) echo 'last-news category';?>" role="main">

                <h1 class="page-title">Результат поиска</h1>

                <div class="entry">

                    <?php wp_reset_query(); ?>

                </div>

                <?php if(have_posts()): ?>



                    <?php while(have_posts()): ?>



                        <?php the_post(); ?>

                        <article class="item">

                            <h2 class="item-title">

                                <?php $title = get_the_title(); $keys= explode(" ",$s); $title = preg_replace('/('.implode('|', $keys) .')/iu', '<mark class="search-excerpt">\0</mark>', $title); ?>

                                <a href="<?php the_permalink(); ?>"><?php echo $title; ?></a>

                            </h2>

                            <div class="item-info">

                                <?php

                                $cat = get_the_category();

                                if($cat[0]->cat_name != '') {

                                    $cat_name = 'Категория: '.$cat[0]->cat_name.'&nbsp;/&nbsp;';

                                } else {

                                    $cat_name = '';

                                }

                                ?>

                                <?php echo $cat_name; ?>

                                Дата: <?php the_time('j F Y'); ?>

                            </div>



                            <?php if(get_image_path($post->ID) != ''):?>

                                <div class="item-img">

                                    <a href="<?php the_permalink(); ?>"><img src="<?php echo get_image_path($post->ID); ?>" alt="" title="<?php the_title(); ?>" /></a>

                                </div>

                            <?endif; ?>



                            <p class="item-text">

                                <?php

                                $content = get_the_content();

                                $content = strip_tags($content);

                                echo mb_substr($content, 0, 270). '...';

                                ?>

                                <a href="<?php the_permalink(); ?>"> Читать далее <i class="fa fa-arrow-circle-o-right"></i></a>

                            </p>

                            <div class="clear"></div>

                        </article>

                    <?php endwhile ?>

                <?php endif ?>



                <?php if (function_exists("emm_paginate")) :

                    emm_paginate();

                endif; ?>

            </section>

        </div>



        <div class="unit-30 pull-left">

            <aside class="sidebar" role="complementary">

                <?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('Сайтбар сайта') ) : ?>

                <?php endif; ?>

            </aside>

        </div>

    </div>





<?php get_footer(); ?>