<?php get_header(); ?>





    <!-- CATEGORY OF CATALOG :: start -->
<section class="catalog_categories">
    <div class="units-row">
        <?php $block_title_1 = get_option('WOOBISNES_welcome'); ?>
        <?php if(!empty($block_title_1)): ?>
        <div class="unit-100 border-line">
            <h3 class="block-triangle">
                <?php echo $block_title_1; ?>
                <br />
                <small class="jeter">
                    <?php echo get_option('WOOBISNES_welcome2'); ?>
                </small>
            </h3>
            <div class="triangle-down"></div>
        </div>
        <?php endif; ?>

        <?php
        $args = array(
            'taxonomy'     => 'product_cat',
            'orderby'      => 'id',
            'show_count'   => 0,
            'pad_counts'   => 0,
            'hierarchical' => 1,
            'title_li'     => '',
            'hide_empty'   => 0
        );
        $all_categories = get_categories( $args ); ?>
        <ul class="product-cat">
        <?php  foreach ($all_categories as $cat): ?>
            <?php if($cat->category_parent == 0) : $category_id = $cat->term_id; ?>
                <?php
                // get the thumbnail id using the queried category term_id
                $thumbnail_id = get_woocommerce_term_meta( $category_id, 'thumbnail_id', true );

                // get the image URL
                if ( $thumbnail_id ) {
                    $image = wp_get_attachment_image_src( $thumbnail_id, 'shop_catalog');
                    $image = $image[0];
                } else {
                    $image = wc_placeholder_img_src();
                }
                ?>

                <li class="product-cat_item">
                    <a href="<?php echo get_term_link($cat->slug, 'product_cat'); ?>">
                        <span class="product-cat_img"><img src="<?php echo $image; ?>" alt="<?php echo $cat->name; ?>"></span>
                        <h3 class="product-cat_title"><?php echo $cat->name; ?></h3>
                    </a>
                </li>
            <?php endif; ?>
        <?php endforeach; ?>
        </ul>
    </div>
</section>
<!-- CATEGORY OF CATALOG :: end -->


<!-- NEW ITEMS :: start -->
<section class="last-items">
    <?php $block_title_2 = get_option('WOOBISNES_welcomeshop'); ?>
        <?php if(!empty($block_title_2)): ?>
        <div class="units-row">
            <div class="unit-100 border-line">
                <h3 class="block-triangle">
                    <?php echo $block_title_2; ?>
                    <br />
                    <small><?php echo get_option('WOOBISNES_welcome2shop'); ?> </small>
                </h3>
                <div class="triangle-down"></div>
            </div>
        </div>
        <?php endif; ?>

        <div id="owl-last-items">
        <?php
            $args = array(
                'post_type' => 'product',
                'stock' => 0,
                'posts_per_page' => 10,
        //        'orderby' =>'rand',
                'order' => 'DESC'
            );
            $loop = new WP_Query( $args );
            while ( $loop->have_posts() ) : $loop->the_post();
                global $product;
                $image_link = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID));
            ?>
            <article class="item">

                <div class="item-img">
                    <a href="<?php the_permalink(); ?>">
                        <img src="<?php echo $image_link[0]; ?>" alt="" title="<?php the_title(); ?>" />
                    </a>
                </div>

                <h3 class="item-title">
                    <a href="<?php the_permalink(); ?>"><?php echo get_the_title(); ?></a>
                </h3>

                <?php if ( $price_html = $product->get_price_html() ) : ?>
                    <div class="item-price"><?php echo $price_html; ?></div>
                <?php endif; ?>

                <a href="<?php the_permalink(); ?>" class="button"><i class="fa fa-shopping-cart"></i>Купить</a>

            </article>

        <?php endwhile; ?>
        <?php wp_reset_query(); ?>
        </div>

</section>
<!-- NEW ITEMS :: end -->



<!-- LAST NEWS :: start -->
<section class="last-news">
    <?php $block_title_2 = get_option('WOOBISNES_welcomeshop3'); ?>
    <?php if(!empty($block_title_2)): ?>
        <div class="units-row">
            <div class="unit-100 border-line">
                <h3 class="block-triangle">
                    <?php echo $block_title_2; ?>
                    <br />
                    <small><?php echo get_option('WOOBISNES_welcome3shop'); ?> </small>
                </h3>
                <div class="triangle-down"></div>
            </div>
        </div>
    <?php endif; ?>

    <?php query_posts( 'posts_per_page=6' ) ?>
    <?php if(have_posts()): ?>
        <div id="owl-last-news" class="owl-carousel">
        <?php while(have_posts()): ?>
            <?php the_post(); ?>
            <article class="item">
                <h2 class="item-title">
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h2>
                <div class="item-info">
                    Категория: <?php the_category('single'); //$cat = get_the_category(); echo $cat[0]->cat_name; ?>&nbsp;/&nbsp;
                    Дата: <?php the_time('j F Y'); ?> <!-- в <?php the_time('G:i'); ?> -->
                </div>

                <?php if(get_image_path($post->ID) != ''):?>
                    <div class="item-img">
                        <a href="<?php the_permalink(); ?>"><img src="<?php echo get_image_path($post->ID); ?>" alt="" title="<?php the_title(); ?>" /></a>
                    </div>
                <?endif; ?>

                <p class="item-text">
                    <?php
                        $content = get_the_content();
                        $content = strip_tags($content);
                        echo mb_substr($content, 0, 270). '...';
                    ?>
                    <a href="<?php the_permalink(); ?>"> Читать далее <i class="fa fa-arrow-circle-o-right"></i></a>
                </p>
                <div class="clear"></div>
            </article>
        <?php endwhile ?>
        </div>
    <?php endif ?>

    <?php wp_reset_query(); ?>
</section>
<!-- LAST NEWS :: end -->


<?php get_footer(); ?>