<!DOCTYPE html>
<html dir="ltr" lang="ru-RU">
<head>
<link rel="shortcut icon" href="<?php bloginfo('stylesheet_directory'); ?>/favicon.png" />
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="shortcut icon" href="<?php echo get_option('WOOBISNES_favicon'); ?>" />
<meta name="keywords" content="<?php echo get_option('WOOBISNES_keywords'); ?>" />
<meta name="description" content="<?php echo get_option('WOOBISNES_description'); ?>" />
<?php wp_head(); ?>
<title><?php if (is_home () ) {    bloginfo('name');} elseif ( is_category() ) {    single_cat_title(); echo ' - ' ; bloginfo('name');} elseif (is_single() ) {    single_post_title();} elseif (is_page() ) {    bloginfo('name'); echo ': '; single_post_title();} else {    wp_title('',true);} ?></title>
<!--[if IE]>
<script src="<?php bloginfo('template_directory'); ?>/js/html5shiv.min.js"></script>
<script src="<?php bloginfo('template_directory'); ?>js/respond.src.js"></script>
<![endif]-->
<script type="text/javascript" src="//vk.com/js/api/openapi.js?121"></script>
<?php
    if ( is_singular() && get_option( 'thread_comments' ) )
    wp_enqueue_script( 'comment-reply' );
?>

</head>

<body <?php body_class(); ?>>

<?php
    $top_phone = get_option('WOOBISNES_hederpfone');
?>
<header class="header">
    <div class="bottom-header">
        <div class="units-row ">
            <!-- LOGO -->
            <div class="unit-30">

                <?php
                // Value from Image Upload
                $Logotip_sitelogo = get_option('WOOBISNES_Logotip_sitelogo');
                ?>
                <?php if(!empty($Logotip_sitelogo)): ?>
                    <a href="<?php echo get_home_url(); ?>" class="logo" >
                        <img src="<?php echo $Logotip_sitelogo; ?>" class="img-responsive"/>
                        <span class="logo_description"><?php echo bloginfo('description'); ?></span>
                    </a>
                <?php else: ?>
                    <a href="<?php echo get_home_url(); ?>" class="logo">
                        <div class="logo_title"><?php echo bloginfo('name'); ?></div>
                        <div class="logo_description"><?php echo bloginfo('description'); ?></div>
                    </a>

                <?php endif; ?>

            </div>


            <div class="unit-70">
                <!-- MENU -->
                <nav class="navmenu" role="navigation">
                    <a id="touch-menu" class="mobile-menu" href="#">
                        <i class="fa fa-th-large fa-lg"></i>
                    </a>
                    <?php wp_nav_menu( array(
                        'theme_location' => 'top',
                        'menu_id' => 'navigation'
                    )); ?>
                </nav>

                <!-- Search -->

            </div>
        </div>
    </div>


</header>

<div class="sub-header">
    <?php
        $textblock = get_option('WOOBISNES_textblock');
    ?>
    <div class="units-row">
        <?php if ($textblock != ''): ?>
        <div class="unit-50">
            <p style="text-align: justify;"><?php echo $textblock; ?></p>
        </div>
        <?php endif; ?>
        <div class="<?php if ($textblock != ''): ?> unit-50 <?php else : ?> unit-100<?php endif; ?>">
            <div class="sub-header-search" role="search">
                <form role="search" method="get" class="search-form clearfix" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
                    <input type="search" id="woocommerce-product-search-field" class="search-text" placeholder="<?php echo esc_attr_x( 'Что ищем?', 'placeholder', 'woocommerce' ); ?>" value="<?php get_search_query(); ?>" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label', 'woocommerce' ); ?>" />
                    <input type="submit" value="<?php echo esc_attr_x( 'Search', 'submit button', 'woocommerce' ); ?>" class="button button-color"/>
                    <!-- <input type="hidden" name="post_type" value="product,post" /> -->
                </form>
            </div>
        </div>
    </div>


</div>


<?php
$slayd_1 = get_option('WOOBISNES_slayd1');
$slayd_1_link = get_option('WOOBISNES_slink1');
$slayd_2 = get_option('WOOBISNES_slayd2');
$slayd_2_link = get_option('WOOBISNES_slink2');
$slayd_3 = get_option('WOOBISNES_slayd3');
$slayd_3_link = get_option('WOOBISNES_slink3');
$slayd_4 = get_option('WOOBISNES_slayd4');
$slayd_4_link = get_option('WOOBISNES_slink4');
$slayd_5 = get_option('WOOBISNES_slayd5');
$slayd_5_link = get_option('WOOBISNES_slink5');
if ( is_front_page() && is_home() ) :
if(!empty($slayd_1) || !empty($slayd_2) || !empty($slayd_3) || !empty($slayd_4) || !empty($slayd_5)):
    ?>
    <!-- SLIDER :: start -->
    <div class="slider">
        <div class="flexslider">
            <ul class="slides">
                <?php if(!empty($slayd_1)): ?>
                    <li>
                        <?php if(!empty($slayd_1_link)) :?>
                            <a href="<?php echo $slayd_1_link; ?>">
                                <?php echo '<img src="'.$slayd_1.'" />'; ?>
                            </a>
                        <?php else : ?>
                            <?php echo '<img src="'.$slayd_1.'" />'; ?>
                        <?php endif; ?>
                    </li>
                <?php endif; ?>

                <?php if(!(empty($slayd_2))): ?>
                    <li>
                        <?php if(!empty($slayd_2_link)) :?>
                            <a href="<?php echo $slayd_2_link; ?>">
                                <?php echo '<img src="'.$slayd_2.'" />'; ?>
                            </a>
                        <?php else : ?>
                            <?php echo '<img src="'.$slayd_2.'" />'; ?>
                        <?php endif; ?>
                    </li>
                <?php endif; ?>

                <?php if(!(empty($slayd_3))): ?>
                    <li>
                        <?php if(!empty($slayd_3_link)) :?>
                            <a href="<?php echo $slayd_3_link; ?>">
                                <?php echo '<img src="'.$slayd_3.'" />'; ?>
                            </a>
                        <?php else : ?>
                            <?php echo '<img src="'.$slayd_3.'" />'; ?>
                        <?php endif; ?>
                    </li>
                <?php endif; ?>

                <?php if(!(empty($slayd_4))): ?>
                    <li>
                        <?php if(!empty($slayd_4_link)) :?>
                            <a href="<?php echo $slayd_4_link; ?>">
                                <?php echo '<img src="'.$slayd_4.'" />'; ?>
                            </a>
                        <?php else : ?>
                            <?php echo '<img src="'.$slayd_4.'" />'; ?>
                        <?php endif; ?>
                    </li>
                <?php endif; ?>

                <?php if(!(empty($slayd_5))): ?>
                    <li>
                        <?php if(!empty($slayd_5_link)) :?>
                            <a href="<?php echo $slayd_5_link; ?>">
                                <?php echo '<img src="'.$slayd_5.'" />'; ?>
                            </a>
                        <?php else : ?>
                            <?php echo '<img src="'.$slayd_5.'" />'; ?>
                        <?php endif; ?>
                    </li>
                <?php endif; ?>
            </ul>
            <div class="custom-navigation">
                <a href="#" class="flex-prev"><i class="fa fa-chevron-left"></i></a>
                <a href="#" class="flex-next"><i class="fa fa-chevron-right"></i></a>
            </div>
        </div>

    </div>
    <!-- SLIDER :: end -->
<?php endif;
endif; ?>


<div id="wrapper">