<?php

add_theme_support( 'automatic-feed-links' );

add_theme_support( 'custom-background' );



/************************************

 * Подключаем настройки для темы

 *************************************/

require_once(TEMPLATEPATH . '/admin/admin-functions.php');

 require_once(TEMPLATEPATH . '/admin/admin-interface.php');

 require_once(TEMPLATEPATH . '/admin/theme-settings.php'); 





function trim_title_chars($count, $after) {  

  $title = get_the_title();  

  if (mb_strlen($title) > $count) $title = mb_substr($title,0,$count);  

  else $after = '';  

  echo $title . $after;  

}



/************************************

 * Регистрация сайтбаров

 *************************************/

if ( function_exists('register_sidebar') ) {

	register_sidebar(array(

		'name' => 'Сайтбар woocommerce',

		'before_widget' => '<div id="%1$s" class="widget %2$s">',

		'after_widget' => '</div>',

		'before_title' => '<div class="widget-header"><h4 class="widget-title">',

		'after_title' => '</h4><div class="triangle-down"></div></div>',

	));





	register_sidebar(array(

		'name' => 'Сайтбар сайта',

		'before_widget' => '',

		'after_widget' => '',

		'before_title' => '<div class="widget-header"><h4 class="widget-title">',

		'after_title' => '</h4><div class="triangle-down"></div></div>',

	));



}







/**
 * Enqueue scripts and styles.
 */

function WOOBISNES_scripts() {



	// Load our main stylesheet.

	wp_enqueue_style( 'theme-style', get_stylesheet_uri() );

	wp_enqueue_style('font-OpenSans', '//fonts.googleapis.com/css?family=Open+Sans:400,300,700&subset=latin,cyrillic', array() );

	wp_enqueue_style('font-PTSans', '//fonts.googleapis.com/css?family=PT+Sans:400,700&subset=cyrillic,latin', array() );



	wp_enqueue_script( 'theme-jquery', get_template_directory_uri() . '/js/jquery-1-8-2.js', array(), '', false );
	// wp_enqueue_script( 'theme-jquery-migrate', get_template_directory_uri() . '/js/jquery-migrate.js', array(), '', true );

	wp_enqueue_script( 'theme-jquery-cookie', get_template_directory_uri() . '/js/jquery.cookie.js', array(), '', true );

	wp_enqueue_script( 'mCustomScrollbar-js', get_template_directory_uri() . '/js/jquery.mCustomScrollbar.concat.min.js', array(), null, true );

	wp_enqueue_script( 'easyResponsiveTabs-js', get_template_directory_uri() . '/js/easyResponsiveTabs.js', array(), null, true );

	wp_enqueue_script( 'touchwipe-js', get_template_directory_uri() . '/js/jquery.touchwipe.min.js', array(), null, true );

	wp_enqueue_script( 'custom-js', get_template_directory_uri() . '/js/custom.js', array(), null, true );
	// wp_enqueue_script( 'add-to-cart-variation-js', '//businki-lentochki.by/wp-content/plugins/woocommerce/assets/js/frontend/add-to-cart-variation.js', array(), null, true );



	if ( is_front_page() && is_home() ) {

		wp_enqueue_script( 'flexslider-js', get_template_directory_uri() . '/js/jquery.flexslider-min.js', array(), null, true );

		wp_enqueue_script( 'flexslider.init-js', get_template_directory_uri() . '/js/flexslider.init.js', array(), null, true );

		wp_enqueue_script( 'carousel-js', get_template_directory_uri() . '/js/owl.carousel.min.js', array(), null, true );

		wp_enqueue_script( 'carousel.init-js', get_template_directory_uri() . '/js/owl.carousel.init.js', array(), null, true );

	}



}

add_action( 'wp_enqueue_scripts', 'WOOBISNES_scripts' );





/************************************

 * Вывод похожих товаров

 *************************************/

add_filter( 'woocommerce_output_related_products_args', 'jk_related_products_args' );
 function jk_related_products_args( $args ) {
 
$args['posts_per_page'] = 3; // количество "Похожих товаров"
 $args['columns'] = 3; // количество колонок
 return $args;
}

add_filter( 'woocommerce_product_tabs', 'devise_woo_rename_reviews_tab', 98);
function devise_woo_rename_reviews_tab($tabs) {

$tabs['additional_information']['title'] = 'Характеристики';

return $tabs;
}



/************************************

 * Подключаем меню

*************************************/

register_nav_menus(array(

'top' => 'Верхнее меню'

));



/************************************

 * Переопределение стандартных переменных

 *************************************/

add_theme_support( 'post-thumbnails' );

set_post_thumbnail_size( 254, 150, false );

add_image_size('featured-post-thumbnail',430,280,true);

add_image_size('slider-thumbnail',795,290,true);





/************************************

 * Включаем поддержку WooCommerce

 *************************************/

add_theme_support( 'woocommerce' );





/************************************

 * Получаем адрес картинки

 *************************************/

function get_image_path ($post_id = null) {

	if ($post_id == null) {

		global $post;

		$post_id = $post->ID;

	}

	$theImageSrc = wp_get_attachment_url( get_post_thumbnail_id($post_id) );

	global $blog_id;

	if (isset($blog_id) && $blog_id > 0) {

		$imageParts = explode('/files/', $theImageSrc);

		if (isset($imageParts[1])) {

			$theImageSrc = '/blogs.dir/' . $blog_id . '/files/' . $imageParts[1];

		}

	}

	return $theImageSrc;

}





/************************************

 * Отключаем стандартные виджеты Wordpess

 *************************************/

function unregister_default_wp_widgets() {

    unregister_widget('WP_Widget_Pages');

    

    unregister_widget('WP_Widget_Archives');

    unregister_widget('WP_Widget_Links');

    unregister_widget('WP_Widget_Meta');

    unregister_widget('WP_Widget_Search');

   

    unregister_widget('WP_Widget_Categories');

    unregister_widget('WP_Widget_Recent_Posts');

    unregister_widget('WP_Widget_Recent_Comments');

    unregister_widget('WP_Widget_RSS');

    unregister_widget('WP_Widget_Tag_Cloud');

    unregister_widget('WP_Nav_Menu_Widget');

}

add_action('widgets_init', 'unregister_default_wp_widgets', 1);







/************************************

 * Вывод изображения категории на странице категории

 * Изображение выводится если имеется описание категории

 *************************************/

// Удаляем стандартную функцию вывода описания категории

remove_action('woocommerce_archive_description', 'woocommerce_taxonomy_archive_description');

add_filter( 'woocommerce_archive_description', 'woocommerce_category_image',1 );

function woocommerce_category_image() {

    if ( is_product_category() ){

	    global $wp_query;

	    $cat = $wp_query->get_queried_object();

	    $thumbnail_id = get_woocommerce_term_meta( $cat->term_id, 'thumbnail_id', true );

	    $image = wp_get_attachment_url( $thumbnail_id );





		if ( is_tax( array( 'product_cat', 'product_tag' ) ) && 0 === absint( get_query_var( 'paged' ) ) ) {

			$description = wc_format_content( term_description() );

			if ( $description ) {

				if ( $image ) {

					echo '<img class="category-product-image" src="' . $image . '" alt="'.$cat->name.'" />';

				}

				echo '<div class="term-description kaseo">' . $description . '</div>';

			}

		}



	}



}







/************************************

 * Вывод комментариев

 *************************************/

function Maximus_comment($comment, $args, $depth) {



    $isByAuthor = false;



    if($comment->comment_author_email == get_the_author_meta('email')) {

        $isByAuthor = true;

    }



    $GLOBALS['comment'] = $comment; ?>

   <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">

     

     <div id="comment-<?php comment_ID(); ?>" class="comment-body clear">

     

   <?php echo get_avatar($comment,$size='55'); ?>

      

      <div class="comment-author vcard">

         <?php printf(__('%s'), get_comment_author_link()) ?> 

		 <?php if($isByAuthor) { ?><span class="author-tag"><?php _e('(Автор)') ?></span><?php } ?>

      </div>



      <div class="comment-meta commentmetadata">

	  	<?php printf(__('%1$s at %2$s'), get_comment_date(),  get_comment_time()) ?>

		<?php edit_comment_link(__('(Редактировать)'),'  ','') ?> &middot; 

		<?php comment_reply_link(array_merge( $args, array('depth' => $depth, 'max_depth' => $args['max_depth']))) ?>

      </div>

<div class="comment-inner">

<?php if ($comment->comment_approved == '0') : ?>

<em class="moderation"><?php _e('Ваш комментарий отправлен на проверку.') ?></em>

<br />

<?php endif; ?>

<?php comment_text() ?>

</div>

</div>

<?php

}









/************************************

 * Ссылка на настройку темы

 *************************************/

add_action( 'wp_before_admin_bar_render', 'optionsframework_adminbar' );



function optionsframework_adminbar() {



	global $wp_admin_bar;



	$wp_admin_bar->add_menu( array(

		'parent' => 'appearance',

		'id' => 'of_theme_options',

		'title' => __( 'Настроить тему WOObizness' ),

		'href' => admin_url( 'admin.php?page=siteoptions' )

  ));



}



/************************************

 * Добавляем автора в админку

 *************************************/

function remove_footer_admin () {

    echo '<div class="inner_copy"><span style="font-style:italic; ">Разработка сайта: <a href="http://kaseo.ru" target="_blank" title="Перейти на сайт разработчика">А. Климов</a> | <a href="//businki-lentochki.by/Руководство по сайту businki-lentochki.by.doc">Скачать руководство по сайту</a> | <a href="//businki-lentochki.by/Site_Guide_businki-lentochki.by">Альтернативная ссылка на руководство по сайту</a></span></div>';

} 

add_filter('admin_footer_text', 'remove_footer_admin');





/************************************

 * подключаем функцию активации мета блока SEO

 *************************************/

add_action('add_meta_boxes', 'my_extra_fields', 1);

function my_extra_fields() {

    add_meta_box( 'extra_fields', 'Настройки метаданных страницы [SEO]', 'extra_fields_box_func', 'post', 'normal', 'high'  );

}



// код блока

function extra_fields_box_func( $post ){

?>

	<p>Заголовок страницы (title) не более 60 знаков:

    <label><input type="text" name="extra[title]" value="<?php echo get_post_meta($post->ID, 'title', 1); ?>" style="width:80%" /> </label></p>



	<p>Описание статьи (description) не более 150 знаков:

		<textarea type="text" name="extra[description]" style="width:80%;height:70px;"><?php echo get_post_meta($post->ID, 'description', 1); ?></textarea>

	</p>



   <p>Ключи (keywords) через запятую, 3-5 не более:

    <label><input type="text" name="extra[keywords]" value="<?php echo get_post_meta($post->ID, 'keywords', 1); ?>" style="width:80%" /> </label></p>



	<p>Видимость поста:<br /> <?php $mark_v = get_post_meta($post->ID, 'robotmeta', 1); ?>

		 <label><input type="radio" name="extra[robotmeta]" value="" <?php checked( $mark_v, '' ); ?> /> index,follow</label>

		 <label><input type="radio" name="extra[robotmeta]" value="nofollow" <?php checked( $mark_v, 'nofollow' ); ?> /> nofollow</label>

		 <label><input type="radio" name="extra[robotmeta]" value="noindex" <?php checked( $mark_v, 'noindex' ); ?> /> noindex</label>

		 <label><input type="radio" name="extra[robotmeta]" value="noindex,nofollow" <?php checked( $mark_v, 'noindex,nofollow' ); ?> /> noindex,nofollow</label>

	</p>

<input type="hidden" name="extra_fields_nonce" value="<?php echo wp_create_nonce(__FILE__); ?>" />

<?php

}



/************************************

 * включаем обновление полей при сохранении мета блока

 *************************************/

add_action('save_post', 'my_extra_fields_update', 0);



/* Сохраняем данные, при сохранении поста */

function my_extra_fields_update( $post_id ){

    if ( !wp_verify_nonce($_POST['extra_fields_nonce'], __FILE__) ) return false; // проверка

	if ( defined('DOING_AUTOSAVE') && DOING_AUTOSAVE  ) return false; // если это автосохранение

	if ( !current_user_can('edit_post', $post_id) ) return false; // если юзер не имеет право редактировать запись



	if( !isset($_POST['extra']) ) return false;	



	// Все ОК! Теперь, нужно сохранить/удалить данные

	$_POST['extra'] = array_map('trim', $_POST['extra']);

	foreach( $_POST['extra'] as $key=>$value ){

		if( empty($value) ){

			delete_post_meta($post_id, $key); // удаляем поле если значение пустое

			continue;

		}



		update_post_meta($post_id, $key, $value); // add_post_meta() работает автоматически

	}

	return $post_id;

}





/************************************

 * Постраничная навигация

 *************************************/

function emm_paginate($args = null) {

	$defaults = array(

		'page' => null, 'pages' => null, 

		'range' => 3, 'gap' => 3, 'anchor' => 1,

		'before' => '<nav class="woocommerce-pagination clearfix"><ul class="page-numbers">', 'after' => '</ul></nav>',

		'title' => __(''),

		'nextpage' => __('→'), 'previouspage' => __('←'),

		'echo' => 1

	);



	$r = wp_parse_args($args, $defaults);

	extract($r, EXTR_SKIP);



	if (!$page && !$pages) {

		global $wp_query;



		$page = get_query_var('paged');

		$page = !empty($page) ? intval($page) : 1;



		$posts_per_page = intval(get_query_var('posts_per_page'));

		$pages = intval(ceil($wp_query->found_posts / $posts_per_page));

	}

	

	$output = "";

	if ($pages > 1) {	

		$output .= "$before<li class='emm-title'>$title</li>";

		$ellipsis = "<li class='emm-gap'>...</li>";



		if ($page > 1 && !empty($previouspage)) {

			$output .= "<li><a href='" . get_pagenum_link($page - 1) . "' class='emm-prev'>$previouspage</a></li>";

		}

		

		$min_links = $range * 2 + 1;

		$block_min = min($page - $range, $pages - $min_links);

		$block_high = max($page + $range, $min_links);

		$left_gap = (($block_min - $anchor - $gap) > 0) ? true : false;

		$right_gap = (($block_high + $anchor + $gap) < $pages) ? true : false;



		if ($left_gap && !$right_gap) {

			$output .= sprintf('%s%s%s', 

				emm_paginate_loop(1, $anchor), 

				$ellipsis, 

				emm_paginate_loop($block_min, $pages, $page)

			);

		}

		else if ($left_gap && $right_gap) {

			$output .= sprintf('%s%s%s%s%s', 

				emm_paginate_loop(1, $anchor), 

				$ellipsis, 

				emm_paginate_loop($block_min, $block_high, $page), 

				$ellipsis, 

				emm_paginate_loop(($pages - $anchor + 1), $pages)

			);

		}

		else if ($right_gap && !$left_gap) {

			$output .= sprintf('%s%s%s', 

				emm_paginate_loop(1, $block_high, $page),

				$ellipsis,

				emm_paginate_loop(($pages - $anchor + 1), $pages)

			);

		}

		else {

			$output .= emm_paginate_loop(1, $pages, $page);

		}



		if ($page < $pages && !empty($nextpage)) {

			$output .= "<li><a href='" . get_pagenum_link($page + 1) . "' class='next page-numbers'>$nextpage</a></li>";

		}



		$output .= $after;

	}



	if ($echo) {

		echo $output;

	}



	return $output;

}



function emm_paginate_loop($start, $max, $page = 0) {

	$output = "";

	for ($i = $start; $i <= $max; $i++) {

		$output .= ($page === intval($i)) 

			? "<li><span class='page-numbers current'>$i</span></li>"

			: "<li><a href='" . get_pagenum_link($i) . "' class='page-numbers'>$i</a></li>";

	}

	return $output;

}





/************************************

 * Проверка относится ли пост к дереву категорий

 *************************************/

function post_is_in_descendant_category( $cats, $_post = null )

{

	foreach ( (array) $cats as $cat ) {

		// get_term_children() accepts integer ID only

		$descendants = get_term_children( (int) $cat, 'category');

		if ( $descendants && in_category( $descendants, $_post ) )

			return true;

	}

	return false;

}







/************************************

 * Edit term page

 *************************************/

add_action( 'product_cat_edit_form_fields', 'wpm_taxonomy_edit_meta_field', 10, 2 );



function wpm_taxonomy_edit_meta_field($term) {

 

  // put the term ID into a variable

  $t_id = $term->term_id;

 

  // retrieve the existing value(s) for this meta field. This returns an array

  $term_meta = get_option( "taxonomy_$t_id" );

  $content = $term_meta['custom_term_meta'] ? wp_kses_post( $term_meta['custom_term_meta'] ) : '';

  $settings = array( 'textarea_name' => 'term_meta[custom_term_meta]' );

  ?>

  <tr class="form-field">

  <th scope="row" valign="top"><label for="term_meta[custom_term_meta]">Любой текст или банеры для каждой категории</label></th>

    <td>

      <?php wp_editor( $content, 'product_cat_details', $settings ); ?>

     

    </td>

  </tr>

<?php

}







/************************************

 * Save extra taxonomy fields callback function

 *************************************/

add_action( 'edited_product_cat', 'save_taxonomy_custom_meta', 10, 2 );  

add_action( 'create_product_cat', 'save_taxonomy_custom_meta', 10, 2 );



function save_taxonomy_custom_meta( $term_id ) {

  if ( isset( $_POST['term_meta'] ) ) {

    $t_id = $term_id;

    $term_meta = get_option( "taxonomy_$t_id" );

    $cat_keys = array_keys( $_POST['term_meta'] );

    foreach ( $cat_keys as $key ) {

      if ( isset ( $_POST['term_meta'][$key] ) ) {

        $term_meta[$key] = wp_kses_post( stripslashes($_POST['term_meta'][$key]) );

      }

    }

    // Save the option array.

    update_option( "taxonomy_$t_id", $term_meta );

  }

}













/************************************

 * Display details on product category archive pages

 *************************************/

add_action( 'woocommerce_after_shop_loop', 'wpm_product_cat_archive_add_meta' );



function wpm_product_cat_archive_add_meta() {

  $t_id = get_queried_object()->term_id;

  $term_meta = get_option( "taxonomy_$t_id" );

  $term_meta_content = $term_meta['custom_term_meta'];

  if ( $term_meta_content != '' ) {

    echo '<div class="woo-sc-box normal rounded full">';

      echo apply_filters( 'the_content', $term_meta_content );

    echo '</div>';

  }

}



/************************************

 * Меняем атрибуты прикрепляемых файлов

 *************************************/

add_filter('wp_get_attachment_image_attributes', 'change_attachement_image_attributes', 20, 2);



function change_attachement_image_attributes( $attr, $attachment ){

    // Get post parent

    $parent = get_post_field( 'post_parent', $attachment);



    // Get post type to check if it's product

    $type = get_post_field( 'post_type', $parent);

    if( $type != 'product' ){

        return $attr;

    }



    /// Get title

    $title = get_post_field( 'post_title', $parent);



    $attr['alt'] = $title;

    $attr['title'] = $title;



    return $attr;

}



/************************************

 * Добавляем ссылки поделиться

 *************************************/

//add_action('woocommerce_share','wooshare');

function wooshare(){

	echo'<div data-background-alpha="0.0" data-buttons-color="#ffffff" data-counter-background-color="#ffffff" data-share-counter-size="12" data-top-button="false" data-share-counter-type="disable" data-share-style="1" data-mode="share" data-like-text-enable="false" data-hover-effect="scale" data-mobile-view="true" data-icon-color="#ffffff" data-orientation="horizontal" data-text-color="#000000" data-share-shape="rectangle" data-sn-ids="vk.ok.fb.ps.gp." data-share-size="30" data-background-color="#ffffff" data-preview-mobile="false" data-mobile-sn-ids="fb.vk.tw.wh.ok.vb." data-pid="1448132" data-counter-background-alpha="1.0" data-following-enable="false" data-exclude-show-more="false" data-selection-enable="true" class="uptolike-buttons" ></div>';

?>

	<script type="text/javascript">(function(w,doc) {

	if (!w.__utlWdgt ) {

	w.__utlWdgt = true;

	var d = doc, s = d.createElement('script'), g = 'getElementsByTagName';

	s.type = 'text/javascript'; s.charset='UTF-8'; s.async = true;

	s.src = ('https:' == w.location.protocol ? 'https' : 'http') + '://w.uptolike.com/widgets/v1/uptolike.js';

	var h=d[g]('body')[0];

	h.appendChild(s);

	}})(window,document);

	</script>

<?php

}





if ( ! class_exists( 'WC_nb' ) ) {



	class WC_nb {



		public function __construct() {

			add_action( 'init', array($this, 'init') );

		}



		function init() {

			add_action( 'woocommerce_before_shop_loop_item_title', array( $this, 'woocommerce_show_product_loop_new_badge' ), 30 ); 	// The new badge function



			// Init settings

			$this->settings = array(

				array(

					'name' => __( 'Настройка иконки нового товара', 'woocommerce-new-badge' ),

					'type' => 'title',

					'id' => 'wc_nb_options'

				),

				array(

					'name' 		=> __( 'Новый продукт', 'woocommerce-new-badge' ),

					'desc' 		=> __( "Сколько дней считать товар новым?", 'woocommerce-new-badge' ),

					'id' 		=> 'wc_nb_newness',

					'type' 		=> 'number',

				),

				array( 'type' => 'sectionend', 'id' => 'wc_nb_options' ),

			);



			// Default options

			add_option( 'wc_nb_newness', '30' );



			// Admin

			add_action( 'woocommerce_settings_image_options_after', array( $this, 'admin_settings' ), 20 );

			add_action( 'woocommerce_update_options_catalog', array( $this, 'save_admin_settings' ) );

			add_action( 'woocommerce_update_options_products', array( $this, 'save_admin_settings' ) );

		}



		/*-----------------------------------------------------------------------------------*/

		/* Class Functions */

		/*-----------------------------------------------------------------------------------*/



		// Load the settings

		function admin_settings() {

			woocommerce_admin_fields( $this->settings );

		}



		// Save the settings

		function save_admin_settings() {

			woocommerce_update_options( $this->settings );

		}



		/*-----------------------------------------------------------------------------------*/

		/* Frontend Functions */

		/*-----------------------------------------------------------------------------------*/



		// Display the new badge

		function woocommerce_show_product_loop_new_badge() {

			$postdate 		= get_the_time( 'Y-m-d' );			// Post date

			$postdatestamp 	= strtotime( $postdate );			// Timestamped post date

			$newness 		= get_option( 'wc_nb_newness' ); 	// Newness in days as defined by option



			if ( ( time() - ( 60 * 60 * 24 * $newness ) ) < $postdatestamp ) { // If the product was published within the newness time frame display the new badge

				echo '<span class="wc-new-badge">' . __( 'New', 'woocommerce-new-badge' ) . '</span>';

			}

		}

	}



	$WC_nb = new WC_nb();

}



/************************************

 * Добавляем новую валюту в магазин

 *************************************/

add_filter( 'woocommerce_currencies', 'add_my_currency' );

function add_my_currency( $currencies ) {

     $currencies['BYN'] = __( 'Белорусский рубль BYN', 'woocommerce' );

     return $currencies;

}

add_filter('woocommerce_currency_symbol', 'add_my_currency_symbol', 10, 2);

function add_my_currency_symbol( $currency_symbol, $currency ) {

     switch( $currency ) {

          case 'BYN': $currency_symbol = 'руб'; break;

     }

     return $currency_symbol;

}









/************************************

 * Изменение количества товаров на одной странице магазина

 *************************************/

/*add_filter( 'loop_shop_per_page', create_function( '$cols', 'return 18;' ), 20 ); //18*/
add_filter( 'loop_shop_per_page', function($cols) {return 18;}, 20);//18



/************************************

 * Количество товара в колонке магазина

 *************************************/

add_filter('loop_shop_columns', 'loop_columns');

if (!function_exists('loop_columns')) {

	function loop_columns() {

		return 3;

	}

}



/************************************

 * Отключаем отображение кол-ва результатов поиска

 *************************************/

remove_action ( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );



/************************************

 * Скрыть отображение количества товаров в категории.

 *************************************/

add_filter( 'woocommerce_subcategory_count_html', 'jk_hide_category_count' );

function jk_hide_category_count() {}



add_filter( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating' );

function woocommerce_template_loop_rating() {}





/************************************

 * Переопределяем функцию вывода миниатюры категории

 *************************************/

add_filter('woocommerce_before_subcategory_title', 'woocommerce_subcategory_thumbnail');

function woocommerce_subcategory_thumbnail( $category ) {

	$small_thumbnail_size  	= apply_filters( 'single_product_small_thumbnail_size', 'shop_catalog' );

	$dimensions    			= wc_get_image_size( $small_thumbnail_size );

	$thumbnail_id  			= get_woocommerce_term_meta( $category->term_id, 'thumbnail_id', true  );



	if ( $thumbnail_id ) {

		$image = wp_get_attachment_image_src( $thumbnail_id, $small_thumbnail_size  );

		$image = $image[0];

	} else {

		$image = wc_placeholder_img_src();

	}



	if ( $image ) {

		// Prevent esc_url from breaking spaces in urls for image embeds

		// Ref: http://core.trac.wordpress.org/ticket/23605

		$image = str_replace( ' ', '%20', $image );



		echo '<div class="product-img"><img src="' . esc_url( $image ) . '" alt="' . esc_attr( $category->name ) . '" /></div>';

	}

}



/************************************

 * AJAX добавление товара в корзину

 *************************************/

function mode_theme_update_mini_cart() {

	echo wc_get_template( 'cart/mini-cart.php' );

	die();

}

add_filter( 'wp_ajax_nopriv_mode_theme_update_mini_cart', 'mode_theme_update_mini_cart' );

add_filter( 'wp_ajax_mode_theme_update_mini_cart', 'mode_theme_update_mini_cart' );





/************************************

 * WOOCOMEMRCE BREADCRUMBS

 *************************************/

add_filter( 'woocommerce_breadcrumb_defaults', 'jk_woocommerce_breadcrumbs' );

function jk_woocommerce_breadcrumbs() {

	$url = esc_url( home_url( '/' ) );

	$home_url = esc_url( $url );

	return array(

		'delimiter'   => ' &#47; ',

		'wrap_before' => '<nav class="woocommerce-breadcrumb" itemprop="breadcrumb"><a href="'.$home_url.'"><i class="fa fa-home"></i></a> <i class="fa fa-angle-right"></i> ',

		'wrap_after'  => '</nav>',

		'before'      => '',

		'after'       => '',

		'home'        => _x( 'Home', 'breadcrumb', 'woocommerce' ),

	);

}

add_filter( 'woocommerce_breadcrumb_defaults', 'jk_change_breadcrumb_delimiter' );

function jk_change_breadcrumb_delimiter( $defaults ) {

	// Change the breadcrumb delimeter from '/' to '>'

	$defaults['delimiter'] = ' <i class="fa fa-angle-right"></i> ';

	return $defaults;

}

add_filter( 'woocommerce_breadcrumb_defaults', 'jk_change_breadcrumb_home_text' );

function jk_change_breadcrumb_home_text( $defaults ) {

	// Change the breadcrumb home text from 'Home' to 'Appartment'

	$defaults['home'] = '';

	return $defaults;

}





/************************************

 * Делаем поля в форме заказа WooCommerce необязательными.

 *************************************/

add_filter( 'woocommerce_checkout_fields' , 'no_required_checkout_fields' );

function no_required_checkout_fields( $fields ) {

	$fields['billing']['billing_address_1']['required'] = false;

	$fields['billing']['billing_address_1']['required'] = true;



	$fields['billing']['billing_city']['class'] = array('form-row-first');

	$fields['shipping']['shipping_city']['class'] = array('form-row-first');

	return $fields;

}



/************************************

 * Удаляем лишние поля форме заказа WooCommerce

 *

 * unset($fields['billing']['billing_first_name']);

 * unset($fields['billing']['billing_last_name']);

 * unset($fields['billing']['billing_company']);

 * unset($fields['billing']['billing_address_1']);

 * unset($fields['billing']['billing_address_2']);

 * unset($fields['billing']['billing_city']);

 * unset($fields['billing']['billing_postcode']);

 * unset($fields['billing']['billing_country']);

 * unset($fields['billing']['billing_state']);

 * unset($fields['billing']['billing_phone']);

 * unset($fields['order']['order_comments']);

 * unset($fields['billing']['billing_email']);

 * unset($fields['account']['account_username']);

 * unset($fields['account']['account_password']);

 * unset($fields['account']['account_password-2']);

 * *************************************/

add_filter( 'woocommerce_checkout_fields' , 'custom_override_checkout_fields' );

function custom_override_checkout_fields( $fields ) {

	// unset($fields['billing']['billing_country']);

	// unset($fields['billing']['billing_company']);

	unset($fields['billing']['billing_state']);



	// unset($fields['shipping']['shipping_country']);

	unset($fields['shipping']['shipping_company']);

	unset($fields['shipping']['shipping_state']);


	$fields['billing']['billing_company'] = array (
		'label'     => 'Отчество',

		'placeholder'   => _x('Отчество', 'placeholder', 'woocommerce'),

		'required'  => true,

		'class'     => array('form-row-wide'),

		'clear'     => true
	);

	// добавляем поле телефона для доставки

	$fields['shipping']['shipping_phone'] = array(

		'label'     => __('Phone', 'woocommerce'),

		'placeholder'   => _x('Телефон', 'placeholder', 'woocommerce'),

		'required'  => true,

		'class'     => array('form-row-wide'),

		'clear'     => true

	);

	// добавляем поле отчество

	// $fields['billing']['billing_patronymic'] = array(

	// 	'label'     => 'Отчество',

	// 	'placeholder'   => _x('Отчество', 'placeholder', 'woocommerce'),

	// 	'required'  => true,

	// 	'class'     => array('form-row-wide'),

	// 	'clear'     => true

	// );

	$fields['shipping']['shipping_patronymic'] = array(

		'label'     => 'Отчество',

		'placeholder'   => _x('Отчество', 'placeholder', 'woocommerce'),

		'required'  => true,

		'class'     => array('form-row-wide'),

		'clear'     => true

	);



	return $fields;

}




/************************************

 * Переопределяем хук вывода данных на странице товара

 *************************************/

//Удаляем стандартное размещение заголовка страницы товара

remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title',5);



// Меняем позицию надписи "Распродажа"

remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );

add_action( 'woocommerce_single_product_summary', 'woocommerce_show_product_sale_flash', 5 );



// Меняем позицию краткого описания

remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );

add_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 40 );





/************************************

 * Переопределяем виджет WOOcommerce Отзывы товаров

 *************************************/

add_action( 'widgets_init', 'override_woocommerce_widgets', 20 );

function override_woocommerce_widgets() {

	unregister_widget( 'WC_Widget_Recent_Reviews' );

	register_widget( 'WC_Widget_Recent_Reviews_kaseo' );

}

include_once( 'widgets/widget-recent-reviews.php' );





/************************************

 * Устанавливаем минимальную сумму заказа

 *************************************/
/*
add_action( 'woocommerce_checkout_process', 'wc_minimum_order_amount' );

add_action( 'woocommerce_before_cart' , 'wc_minimum_order_amount' );

function wc_minimum_order_amount() {
	$minimum = 10;
	if ( WC()->cart->total < $minimum ) {
		if (is_cart() || is_checkout()) {
			wc_print_notice(
				sprintf('Для оформления заказа общая стоимость товаров в вашей корзине должна быть не меньше %s, сейчас общая сумма %s.',
					wc_price($minimum),
					wc_price(WC()->cart->total)
				), 'error'
			);
		}
		else {
			wc_add_notice(
				sprintf('Для оформления заказа общая стоимость товаров в вашей корзине должна быть не меньше %s, сейчас общая сумма %s.',
					wc_price($minimum),
					wc_price(WC()->cart->total)
				), 'error'
			);
		}
	}
}
*/
/************************************

 * Умный показ ошибок PHP

 *************************************/
add_action('init', 'enable_errors');
function enable_errors(){
	if( $GLOBALS['user_level'] < 5 )
		return;
	error_reporting(E_ALL ^ E_NOTICE);
	ini_set("display_errors", 1);
}


/************************************
 * Произвольный порядок товаров WooCommerce
 *************************************/
add_filter( 'woocommerce_get_catalog_ordering_args', 'custom_woocommerce_get_catalog_ordering_args' );
 
function custom_woocommerce_get_catalog_ordering_args( $args ) {
$orderby_value = isset( $_GET['orderby'] ) ? woocommerce_clean( $_GET['orderby'] ) : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby' ) );
 
if ( 'random_list' == $orderby_value ) {
$args['orderby'] = 'rand';
$args['order'] = '';
$args['meta_key'] = '';
}
return $args;
}
 
add_filter( 'woocommerce_default_catalog_orderby_options', 'custom_woocommerce_catalog_orderby' );
add_filter( 'woocommerce_catalog_orderby', 'custom_woocommerce_catalog_orderby' );
 
function custom_woocommerce_catalog_orderby( $sortby ) {
$sortby['random_list'] = 'Случайный';
return $sortby;
}


// add_filter('woocommerce_cart_needs_payment', 'disabled_payment');
// function disabled_payment () {
	
// }

// define the woocommerce_review_order_before_submit callback 
function action_woocommerce_review_order_before_submit(  ) { 
	echo '<label for="agree_dogovor" style="float:left;"><input type="checkbox" name="agree_dogovor" id="agree_dogovor" value="" checked=""> Я принимаю условия</label>';	
    echo '<script>
     $(document).ready(function() {
        var checkbox = $("input#agree_dogovor"),
            button = $("#place_order");
         
         if(checkbox.prop("checked")) button.prop("disabled", false);
         else button.prop("disabled", true);

         checkbox.change(function(){
            if ($(this).prop("checked")) button.prop("disabled", false);
            else button.prop("disabled", true);
        });
    });
    </script>';
}; 
         
// add the action 
add_action( 'woocommerce_review_order_before_submit', 'action_woocommerce_review_order_before_submit', 10, 0 ); 

/************************************
 * Скрываем ненужные пункты админки
 *************************************/
function remove_menus(){
	remove_submenu_page( 'options-general.php','options-writing.php' );        //Настройки: написание
	remove_submenu_page( 'options-general.php','options-reading.php' );        //Настройки: чтение
	remove_submenu_page( 'options-general.php','options-discussion.php' );        //Настройки:обсуждение
	remove_submenu_page( 'options-general.php','options-permalink.php' );        //Настройки:постоянные ссылки
	// remove_submenu_page( 'index.php','update-core.php' );        //Настройки:постоянные ссылки
}
// add_action( 'admin_menu', 'remove_menus' );




/************************************

 * Отключаем обновление плагинов, заданных в массиве

 * в файле wp-config.php

 *************************************/

remove_action( 'load-update-core.php', 'wp_update_plugins' );

// add_filter( 'pre_site_transient_update_plugins', create_function( '$a', "return null;" ) );

wp_clear_scheduled_hook( 'wp_update_plugins' );


//отключение обновления плагинов start
function disable_updates($value) {
   unset($value->response['gwolle-gb/gwolle-gb.php']);
   unset($value->response['woocommerce/woocommerce.php']);
   unset($value->response['woocommerce-prices/woocommerce-prices.php']);
   unset($value->response['woocommerce-pdf-invoices-packing-slips/woocommerce-pdf-invoices-packingslips.php']);
   unset($value->response['woocommerce-category-accordion/woocommerce-category-accordion.php']);
   unset($value->response['woocommerce-cart-tab/cart-tab.php']);
   unset($value->response['export-user-data/export-user-data.php']);
   return $value;
}
add_filter('site_transient_update_plugins', 'disable_updates');
//отключение обновления плагинов end



// запрет обновления выборочных плагинов
/*function filter_plugin_updates( $update ) {    
    global $DISABLE_UPDATE; // см. wp-config.php
    if( !is_array($DISABLE_UPDATE) || count($DISABLE_UPDATE) == 0 ){  return $update;  }
    foreach( $update->response as $name => $val ){
        foreach( $DISABLE_UPDATE as $plugin ){
            if( stripos($name,$plugin) !== false ){
                unset( $update->response[ $name ] );
            }
        }
    }
    return $update;
}
add_filter( 'site_transient_update_plugins', 'filter_plugin_updates' );*/


//===== отключить уведомление об обновлении плагинов и вордпресс=====//
//add_filter('pre_site_transient_update_core',create_function('$a', "return null;"));
add_filter('pre_site_transient_update_core',function($a) {return null;});
wp_clear_scheduled_hook('wp_version_check');
remove_action( 'load-update-core.php', 'wp_update_plugins' );
//add_filter( 'pre_site_transient_update_plugins', create_function( '$a', "return null;" ) );
add_filter( 'pre_site_transient_update_plugins', function($a) {return null;});

//===== Скидка 10% на сумму больше 20 руб.=====//
/*function woo_discount_total(WC_Cart $cart) {

 	$woo_current_price = $cart->subtotal; // Текущая итоговая сумма
	
	if($woo_current_price >= 20) {
	
		$discount = $cart->subtotal * 0.07; // 0.03 - это 3%
		$cart->add_fee("Скидка в 7% за заказ на сумму от 20 рублей ", -$discount);
		
	} 
}
add_action("woocommerce_cart_calculate_fees" , "woo_discount_total");*/

add_action( 'wp_footer', 'cart_refresh_update_qty', 100 );




function cart_refresh_update_qty() {
    if ( is_cart() ) {
        ?>
        <script type="text/javascript">
            jQuery('div.woocommerce').on('change', 'input.qty', function(){
                setTimeout(function() {
                    jQuery('[name="update_cart"]').trigger('click');
                }, 100 );
            });
        </script>
        <?php
    }
}

function true_author_caps(){
	global $pagenow;
	$role = get_role( 'order_manager' ); 

	

	
}


function true_block_admin_pages_redirect() {
	global $pagenow;

	$pages_to_block = array(
		'admin.php'
	);
	if(in_array($pagenow, $pages_to_block)){
	if ( ($_GET['page']=='wc-settings') or ($_GET['page']=='wc-addons') or ($_GET['page']=='wc-status') )
	{
		wp_redirect( admin_url('/') );
		exit;
		}
	}
}
 
// в этом условии необходимо перечислить права, которые необходимо иметь пользователю, чтобы получить доступ
// удалите условие, если нужно закрыть страницы для всех
if(!current_user_can('administrator')){
	add_action('admin_init', 'true_block_admin_pages_redirect');
}
/** Disable Ajax Call from WooCommerce on front page and posts*/
add_action( 'wp_enqueue_scripts', 'dequeue_woocommerce_cart_fragments', 11);
function dequeue_woocommerce_cart_fragments() {
if (is_front_page() || is_single() ) wp_dequeue_script('wc-cart-fragments');
}

/* Вывод дополнительных полей в Консоли статуса заказа
function action_woocommerce_after_dashboard_status_widget() {
    if ( ! current_user_can( 'edit_shop_orders' ) ) {
        return;
    }
    $on_hold_count    = 0;
    $processing_count = 0;

    foreach ( wc_get_order_types( 'order-count' ) as $type ) {
        $counts           = (array) wp_count_posts( $type );
        $on_hold_count    += isset( $counts['wc-on-hold'] ) ? $counts['wc-on-hold'] : 0;
        $processing_count += isset( $counts['wc-processing'] ) ? $counts['wc-processing'] : 0;
    }
    ?>
    <li class="out-of-stock">
        <a href="<?php echo admin_url( 'edit.php?s&post_status=all&post_type=product&action=-1&product_type&stock_status=outofstock&filter_action=Фильтр&paged=1&action2=-1' ); ?>">
            <?php
            printf(
                _n( '<strong>%s order</strong> awaiting processing', '<strong>%s orders</strong> awaiting processing', $processing_count, 'woocommerce' ),
                $processing_count
            );
            ?>
        </a>
    </li>
    <?php
}
add_action( 'woocommerce_after_dashboard_status_widget', 'action_woocommerce_after_dashboard_status_widget' );
*/

// Отключение вкладки (таба) отзывов
add_filter( 'woocommerce_product_tabs', 'sb_woo_remove_reviews_tab', 98);
function sb_woo_remove_reviews_tab($tabs) {
 
unset($tabs['reviews']);
 
return $tabs;
}
?>

