/**
 * global wdp_export_items
 * */

jQuery(document).ready(function () {

    setTimeout( function() {
      jQuery('.import-notice').hide();
    }, 3500);

    jQuery( '.section_choice' ).click( function () {
      jQuery( '.section_choice' ).removeClass( 'active' );
      jQuery( this ).addClass( 'active' );

      jQuery( '.tools-section' ).removeClass( 'active' );
      jQuery( '#' + jQuery( this ).data( 'section' ) + '_section' ).addClass( 'active' );

      window.location.href = jQuery( this ).attr( 'href' );
    } );

    jQuery( '.wdp-export-bulk-ranges' ).click(function () {

      window.open(ajaxurl+"?action=export-csv-bulk-ranges", '_blank');
    });

    setTimeout( function () {
      if ( window.location.hash.indexOf( 'section' ) !== - 1 ) {
        jQuery( '.section_choice[href="' + window.location.hash + '"]' ).click();
      } else {
        jQuery( '.section_choice' ).first().click();
      }
    }, 0 );

    if (window.wdp_export_items) {
        var wdp_export_items = JSON.parse(window.wdp_export_items);

        jQuery('#wdp-export-select').change(function () {
            var selected = jQuery(this).val();
            jQuery('#wdp-export-data').val(JSON.stringify(wdp_export_items[selected]['data'], null, 5));
        }).change();


        jQuery('#wdp-export-data').click(function () {
            jQuery(this).select();
        });

        jQuery('#wdp-import').click(function () {
            if( jQuery('#wdp-import-data').val() === "" ) {
				return false;
			}
        });

	jQuery('#wdp-import-select').change(function () {
            var selected = jQuery(this).val();
            jQuery('.wdp-import-tools-form .wdp-import-type-options').removeClass('active');
            jQuery('.wdp-import-tools-form .wdp-import-type-options-' + selected).addClass('active');
        }).change();
    }

  jQuery('#wdp-migrate-common-to-product-only').click(function () {
    let props = {
      action: 'migrate-common-to-product-only',
    };

    jQuery.post({
      url: ajaxurl,
      data: props,
      dataType: 'json',
      success: (data) => {
        jQuery(this).closest('.tools-section').find('.migration-rules-affected').hide();
        jQuery(this).closest('.migrate-rules-div').find('.migration-rules-affected').text(data.data).show();
      }
    });
  });

  jQuery('#wdp-migrate-product-only-to-common').click(function () {
    let props = {
      action: 'migrate-product-only-to-common',
    };

    jQuery.post({
      url: ajaxurl,
      data: props,
      dataType: 'json',
      success: (data) => {
        jQuery(this).closest('.tools-section').find('.migration-rules-affected').hide();
        jQuery(this).closest('.migrate-rules-div').find('.migration-rules-affected').text(data.data).show();
      }
    });
  });

  jQuery('#manage_bulk_ranges_section .wdp-import-tools-form').on("submit", function (event) {
    let filePath = jQuery(this).siblings("#rules-to-import").val();
    let warning = jQuery(this).siblings(".no-file-warning");
    if (!filePath) {
      warning.show();
      event.preventDefault();
    } else {
      warning.hide();
    }
  })
});
