/**ABDB**/CREATE TABLE `#__woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`),
  KEY `tax_rate_class` (`tax_rate_class`),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/CREATE TABLE `#__woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type` (`location_type`),
  KEY `location_type_code` (`location_type`,`location_code`(90))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/CREATE TABLE `#__woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/**ABDB**/INSERT INTO `#__woocommerce_shipping_zones`  VALUES 
('3', 'Беларусь', '0');
/**ABDB**/CREATE TABLE `#__woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/**ABDB**/INSERT INTO `#__woocommerce_shipping_zone_methods`  VALUES 
('3', '6', 'local_pickup', '3', '1'),
('3', '7', 'local_pickup', '1', '1'),
('3', '8', 'flat_rate', '2', '1');
/**ABDB**/CREATE TABLE `#__woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type` (`location_type`),
  KEY `location_type_code` (`location_type`,`location_code`(90))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/**ABDB**/INSERT INTO `#__woocommerce_shipping_zone_locations`  VALUES 
('3', '3', 'BY', 'country');
/**ABDB**/CREATE TABLE `#__woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=7404706 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/**ABDB**/INSERT INTO `#__woocommerce_sessions`  VALUES 
('7403920', '32fc90e3d9baa63f24f4e50ea025aab5', 'a:14:{s:4:\"cart\";s:1059:\"a:1:{s:32:\"b2eb0ba37504de3a159517b6b2cbf507\";a:12:{s:3:\"key\";s:32:\"b2eb0ba37504de3a159517b6b2cbf507\";s:10:\"product_id\";i:48922;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.21600000000000003;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.21600000000000003;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.27;s:26:\"original_price_without_tax\";d:0.27;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:1:{i:4;a:1:{i:0;d:0.05399999999999999;}}s:8:\"discount\";a:1:{i:4;a:1:{i:0;d:0.05399999999999999;}}s:9:\"new_price\";d:0.21600000000000003;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.22\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.22\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.22\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1514:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_4d222e6ee2eb2d97707278c323205fbb\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:57:\"Термонаклейка (2-3см) \"Нюша\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:57:\"Термонаклейка (2-3см) \"Нюша\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:57:\"Термонаклейка (2-3см) \"Нюша\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763594672'),
('7403921', 'a0e4ba9c15ee24f6392971f7f7fcebdd', 'a:14:{s:4:\"cart\";s:941:\"a:1:{s:32:\"b4d22bb574aed5fdd900a274930252f6\";a:12:{s:3:\"key\";s:32:\"b4d22bb574aed5fdd900a274930252f6\";s:10:\"product_id\";i:8030;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:11.2;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:11.2;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:11.2;s:26:\"original_price_without_tax\";d:11.2;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:11.2;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:397:\"a:15:{s:8:\"subtotal\";s:4:\"11.2\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"11.2\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:5:\"11.20\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1580:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_f6fefaf81a008cdaab13aa9a7876a713\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:79:\"Кружево (6,7см) вязаное (5 метров) хлопок &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:79:\"Кружево (6,7см) вязаное (5 метров) хлопок &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:79:\"Кружево (6,7см) вязаное (5 метров) хлопок &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763594698'),
('7403922', 'ce11f2b2fd8727884f09d98f57a58e2d', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"c2f5a98f538a51b4e13f38d172da0277\";a:12:{s:3:\"key\";s:32:\"c2f5a98f538a51b4e13f38d172da0277\";s:10:\"product_id\";i:78852;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.2;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.2;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.2;s:26:\"original_price_without_tax\";d:1.2;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.2;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.2\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.2\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.20\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1676:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_c2cab4e376c3110d3bab62a473b3ff24\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:110:\"Бабочка (4,5см) шифоновая с длинным тельцем №5 малиновая &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:110:\"Бабочка (4,5см) шифоновая с длинным тельцем №5 малиновая &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:110:\"Бабочка (4,5см) шифоновая с длинным тельцем №5 малиновая &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763594725'),
('7403923', '9ccdf91f9b080d5d25c733bade792a6e', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"85e5e0842d745041f29f57f0f3c7a92c\";a:12:{s:3:\"key\";s:32:\"85e5e0842d745041f29f57f0f3c7a92c\";s:10:\"product_id\";i:29365;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.2;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.2;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.2;s:26:\"original_price_without_tax\";d:1.2;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.2;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.2\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.2\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.20\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";s:337:\"a:1:{s:7:\"success\";a:1:{i:0;a:2:{s:6:\"notice\";s:262:\"<a href=\"https://businki-lentochki.by/cart/\" tabindex=\"1\" class=\"button wc-forward\">Просмотр корзины</a> Вы отложили &ldquo;Заготовка (10см) для топиария &#171;ромашка&#187;&rdquo; в свою корзину.\";s:4:\"data\";a:0:{}}}}\";s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1577:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_deb41324b6a32808062767bffff8574e\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:78:\"Заготовка (10см) для топиария \"ромашка\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:78:\"Заготовка (10см) для топиария \"ромашка\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:78:\"Заготовка (10см) для топиария \"ромашка\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763596158'),
('7403924', '4185ed8340b7488f5ef2e20a52de0a0b', 'a:14:{s:4:\"cart\";s:936:\"a:1:{s:32:\"4493f5351e66c44bc87515f72d07aec2\";a:12:{s:3:\"key\";s:32:\"4493f5351e66c44bc87515f72d07aec2\";s:10:\"product_id\";i:7519;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:2.8;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:2.8;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:2.8;s:26:\"original_price_without_tax\";d:2.8;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:2.8;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"2.8\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"2.8\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"2.80\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1544:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_1d2ba63353153cdfb35ed88918e0d1a6\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:67:\"Бусины (7мм) «с буквами» \"золото\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:67:\"Бусины (7мм) «с буквами» \"золото\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:67:\"Бусины (7мм) «с буквами» \"золото\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763596187'),
('7403925', '840faf9e882c0d58eb7ba5b2001810c9', 'a:14:{s:4:\"cart\";s:942:\"a:1:{s:32:\"7fbf2d8e7b84e90fd9e2698db2d22362\";a:12:{s:3:\"key\";s:32:\"7fbf2d8e7b84e90fd9e2698db2d22362\";s:10:\"product_id\";i:16783;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.78;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.78;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.78;s:26:\"original_price_without_tax\";d:0.78;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.78;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.78\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.78\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.78\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";s:349:\"a:1:{s:7:\"success\";a:1:{i:0;a:2:{s:6:\"notice\";s:274:\"<a href=\"https://businki-lentochki.by/cart/\" tabindex=\"1\" class=\"button wc-forward\">Просмотр корзины</a> Вы отложили &ldquo;Обложка (А4) для учебника, дневника, тетради (120мкм)&rdquo; в свою корзину.\";s:4:\"data\";a:0:{}}}}\";s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1646:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_8f7fe93e29692d04c3c2febc3a149e3d\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:100:\"Обложка (А4) для учебника, дневника, тетради (120мкм) &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:100:\"Обложка (А4) для учебника, дневника, тетради (120мкм) &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:100:\"Обложка (А4) для учебника, дневника, тетради (120мкм) &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763596696'),
('7403926', 'be139a16bafde5a2a0cc0d403e423780', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"89f563302cccc20f324512bb6369c334\";a:12:{s:3:\"key\";s:32:\"89f563302cccc20f324512bb6369c334\";s:10:\"product_id\";i:57435;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:7.9;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:7.9;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:7.9;s:26:\"original_price_without_tax\";d:7.9;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:7.9;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"7.9\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"7.9\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"7.90\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1559:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_8cf3da1714af8aafac2d46e569dd15cb\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:72:\"Молд (5×5см) \"лист чёрной смородины\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:72:\"Молд (5×5см) \"лист чёрной смородины\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:72:\"Молд (5×5см) \"лист чёрной смородины\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763596697'),
('7403927', 'c639ea8f7651babf2319140f2af59542', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"44d5a62d31a467c4504308fb09c6c0cf\";a:12:{s:3:\"key\";s:32:\"44d5a62d31a467c4504308fb09c6c0cf\";s:10:\"product_id\";i:44080;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.1;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.1;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.1;s:26:\"original_price_without_tax\";d:0.1;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.1;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"0.1\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"0.1\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.10\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1520:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_3eec9e6c75d3725fab4c13b2cc1ea5af\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:59:\"Пакет (10×15см) \"Париж+платье\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:59:\"Пакет (10×15см) \"Париж+платье\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:59:\"Пакет (10×15см) \"Париж+платье\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763597424'),
('7403928', 'f0092ab8423124a1d02d12e139649b15', 'a:14:{s:4:\"cart\";s:933:\"a:1:{s:32:\"a17c8f64019807c6c53ea7fad557679b\";a:12:{s:3:\"key\";s:32:\"a17c8f64019807c6c53ea7fad557679b\";s:10:\"product_id\";i:25999;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:5.6;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:5.6;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:7;s:26:\"original_price_without_tax\";d:7;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:5.6;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"5.6\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"5.6\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"5.60\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1571:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_01cc3de38f1daf92504e30e0d857b241\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:76:\"Бумага гофрированная цвет 17Е/1 бурый &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:76:\"Бумага гофрированная цвет 17Е/1 бурый &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:76:\"Бумага гофрированная цвет 17Е/1 бурый &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763597915'),
('7403929', 'bbb6eeb7267470424860b3d17fdc5380', 'a:14:{s:4:\"cart\";s:942:\"a:1:{s:32:\"110717adf61f48167e0344209397ee49\";a:12:{s:3:\"key\";s:32:\"110717adf61f48167e0344209397ee49\";s:10:\"product_id\";i:37109;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.85;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.85;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.85;s:26:\"original_price_without_tax\";d:0.85;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.85;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.85\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.85\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.85\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1550:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_9ba4c0e986db35b3118b1147dc07f761\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:69:\"Декупажная карта (21×29,5см) \"Париж\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:69:\"Декупажная карта (21×29,5см) \"Париж\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:69:\"Декупажная карта (21×29,5см) \"Париж\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763597941'),
('7403930', '68377fbc7df27bac719446a1cb01c0af', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"4b496f9e3202ec36b3058ebe58ecfd67\";a:12:{s:3:\"key\";s:32:\"4b496f9e3202ec36b3058ebe58ecfd67\";s:10:\"product_id\";i:63798;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:5.9;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:5.9;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:5.9;s:26:\"original_price_without_tax\";d:5.9;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:5.9;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"5.9\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"5.9\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"5.90\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1628:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_9f7b9250875f7e6abdf1c10fbf142a40\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:95:\"Тесьма (0,9см) «вьюнчик» тёмно-зелёная (10 метров) &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:95:\"Тесьма (0,9см) «вьюнчик» тёмно-зелёная (10 метров) &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:95:\"Тесьма (0,9см) «вьюнчик» тёмно-зелёная (10 метров) &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763597997'),
('7403931', '1b334624a6b02681fd92b429d442aab3', 'a:14:{s:4:\"cart\";s:972:\"a:1:{s:32:\"110717adf61f48167e0344209397ee49\";a:12:{s:3:\"key\";s:32:\"110717adf61f48167e0344209397ee49\";s:10:\"product_id\";i:37109;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.85;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.85;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:4:{s:14:\"original_price\";d:0.85;s:26:\"original_price_without_tax\";d:0.85;s:18:\"original_price_tax\";d:0;s:20:\"initial_custom_price\";N;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.85;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.85\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.85\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.85\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";s:6:\"a:0:{}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1550:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_9bd91a8cccbe2bd34c2e7560bfae10f7\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:69:\"Декупажная карта (21×29,5см) \"Париж\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:69:\"Декупажная карта (21×29,5см) \"Париж\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:69:\"Декупажная карта (21×29,5см) \"Париж\" &times; 1\";}}}}\";}', '1763598428'),
('7403933', '05677b9fb075da10ce4109f3228a6ffa', 'a:14:{s:4:\"cart\";s:927:\"a:1:{s:32:\"67039300a84e6edee2cea5ae4d7eb634\";a:12:{s:3:\"key\";s:32:\"67039300a84e6edee2cea5ae4d7eb634\";s:10:\"product_id\";i:16492;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:7;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:7;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:7;s:26:\"original_price_without_tax\";d:7;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:7;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:390:\"a:15:{s:8:\"subtotal\";s:1:\"7\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:1:\"7\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"7.00\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1613:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_3444e391b23c337553a53104ceed4876\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:90:\"Шерсть (088) для валяния полутонкая \"брусника\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:90:\"Шерсть (088) для валяния полутонкая \"брусника\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:90:\"Шерсть (088) для валяния полутонкая \"брусника\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763598511'),
('7403934', 'd389cc663bad6edb89134225bc36e463', 'a:14:{s:4:\"cart\";s:1943:\"a:2:{s:32:\"f76d445d6ca1d2d62872bc0ea1c298bf\";a:12:{s:3:\"key\";s:32:\"f76d445d6ca1d2d62872bc0ea1c298bf\";s:10:\"product_id\";i:39237;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:3;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:2.4;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:2.4;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:4:{s:14:\"original_price\";d:0.8;s:26:\"original_price_without_tax\";d:0.7999999999999999;s:18:\"original_price_tax\";d:0;s:20:\"initial_custom_price\";N;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.8;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}s:32:\"38cefcbd8fdddeba6acabcef529887d7\";a:12:{s:3:\"key\";s:32:\"38cefcbd8fdddeba6acabcef529887d7\";s:10:\"product_id\";i:41310;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:2;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.6;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.6;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:4:{s:14:\"original_price\";d:0.8;s:26:\"original_price_without_tax\";d:0.8;s:18:\"original_price_tax\";d:0;s:20:\"initial_custom_price\";N;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.8;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:390:\"a:15:{s:8:\"subtotal\";s:1:\"4\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:1:\"4\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"4.00\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1673:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_a0c606351a3de38e2862bbcc479ddca9\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:109:\"Резинки (3см) фигурные чёрные &times; 3, Резинки (4см) черные &times; 2\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:109:\"Резинки (3см) фигурные чёрные &times; 3, Резинки (4см) черные &times; 2\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:109:\"Резинки (3см) фигурные чёрные &times; 3, Резинки (4см) черные &times; 2\";}}}}\";}', '1763598773'),
('7403939', 'b0e1087b5d7c55b31682cc066823b877', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"df139a4a0fe80d9221879c923a2f2162\";a:12:{s:3:\"key\";s:32:\"df139a4a0fe80d9221879c923a2f2162\";s:10:\"product_id\";i:61009;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.4;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.4;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.4;s:26:\"original_price_without_tax\";d:1.4;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.4;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.4\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.4\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.40\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1565:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_12b23d0be13ad3ac15fcefba5bb59db2\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:74:\"Ткань (35×50см) для рукоделия «буквы» &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:74:\"Ткань (35×50см) для рукоделия «буквы» &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:74:\"Ткань (35×50см) для рукоделия «буквы» &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763599173'),
('7403940', 'e1dd5336390a02d7eb3647d373b217da', 'a:14:{s:4:\"cart\";s:976:\"a:1:{s:32:\"f84819a3e34000ecc13922b34092f303\";a:12:{s:3:\"key\";s:32:\"f84819a3e34000ecc13922b34092f303\";s:10:\"product_id\";i:37790;s:12:\"variation_id\";i:37791;s:9:\"variation\";a:1:{s:19:\"attribute_pa_dizayn\";s:1:\"9\";}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"7ecd5b44e714ba8a476c88edef8e7ff7\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.8;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.8;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.8;s:26:\"original_price_without_tax\";d:1.8;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.8;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.8\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.8\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.80\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1592:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_1b7d00b84167d169865496d9e693854a\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:83:\"Топперы (5,7×15см) деревянные \"цифра 1-9\" - №9 &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:83:\"Топперы (5,7×15см) деревянные \"цифра 1-9\" - №9 &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:83:\"Топперы (5,7×15см) деревянные \"цифра 1-9\" - №9 &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763599275'),
('7403941', '9e6d5bc7d4320060996070ee49e86969', 'a:14:{s:4:\"cart\";s:933:\"a:1:{s:32:\"11a0674eabe73a56fb088d127536a7d5\";a:12:{s:3:\"key\";s:32:\"11a0674eabe73a56fb088d127536a7d5\";s:10:\"product_id\";i:58724;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.7;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.7;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:2;s:26:\"original_price_without_tax\";d:2;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.7;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.7\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.7\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.70\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1574:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_aead39f7d20277fabbcc1b7869988dc7\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:77:\"Фетр (1мм) корейский салатовый мягкий &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:77:\"Фетр (1мм) корейский салатовый мягкий &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:77:\"Фетр (1мм) корейский салатовый мягкий &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763599535'),
('7403942', 'bd9004d8c2c8c2b1b293277166bea685', 'a:14:{s:4:\"cart\";s:1024:\"a:1:{s:32:\"fbd60b136e90edeee0ed662a53a7a41c\";a:12:{s:3:\"key\";s:32:\"fbd60b136e90edeee0ed662a53a7a41c\";s:10:\"product_id\";i:48917;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.44;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.44;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.8;s:26:\"original_price_without_tax\";d:1.8;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:1:{i:4;a:1:{i:0;d:0.3599999999999999;}}s:8:\"discount\";a:1:{i:4;a:1:{i:0;d:0.3599999999999999;}}s:9:\"new_price\";d:1.4400000000000002;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"1.44\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"1.44\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.44\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1541:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_66e192523ee5d041b51a2c5a36aab63d\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:66:\"Термонаклейка \"глазки зелёные\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:66:\"Термонаклейка \"глазки зелёные\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:66:\"Термонаклейка \"глазки зелёные\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763599942'),
('7403943', '163f9ea4c6b643fca950f0656056709d', 'a:14:{s:4:\"cart\";s:971:\"a:1:{s:32:\"109d2dd3608f669ca17920c511c2a41e\";a:12:{s:3:\"key\";s:32:\"109d2dd3608f669ca17920c511c2a41e\";s:10:\"product_id\";i:1528;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.78;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.78;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:4:{s:14:\"original_price\";d:0.78;s:26:\"original_price_without_tax\";d:0.78;s:18:\"original_price_tax\";d:0;s:20:\"initial_custom_price\";N;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.78;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.78\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.78\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.78\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";s:6:\"a:0:{}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1541:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_57047fdb927fc68c7ab93e25a52541e5\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:66:\"Лента (2см) жаккардовая голубая &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:66:\"Лента (2см) жаккардовая голубая &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:66:\"Лента (2см) жаккардовая голубая &times; 1\";}}}}\";}', '1763600091'),
('7403945', 'fb27abc677ac5cf7250d71b9921dd824', 'a:14:{s:4:\"cart\";s:942:\"a:1:{s:32:\"604b22548fbebba00ec67d8b69c09e56\";a:12:{s:3:\"key\";s:32:\"604b22548fbebba00ec67d8b69c09e56\";s:10:\"product_id\";i:20325;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.85;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.85;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.85;s:26:\"original_price_without_tax\";d:1.85;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.85;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"1.85\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"1.85\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.85\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";s:331:\"a:1:{s:7:\"success\";a:1:{i:0;a:2:{s:6:\"notice\";s:256:\"<a href=\"https://businki-lentochki.by/cart/\" tabindex=\"1\" class=\"button wc-forward\">Просмотр корзины</a> Вы отложили &ldquo;Лента (5см) парчовая малиновая с золотом&rdquo; в свою корзину.\";s:4:\"data\";a:0:{}}}}\";s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1589:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_b6b528edcee5f76b6acff03a959707c2\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:82:\"Лента (5см) парчовая малиновая с золотом &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:82:\"Лента (5см) парчовая малиновая с золотом &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:82:\"Лента (5см) парчовая малиновая с золотом &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763600433'),
('7403946', '447ec3b6e0a43cc4bd021d4bcae2d91a', 'a:14:{s:4:\"cart\";s:936:\"a:1:{s:32:\"dd03de08bfdff4d8ab01117276564cc7\";a:12:{s:3:\"key\";s:32:\"dd03de08bfdff4d8ab01117276564cc7\";s:10:\"product_id\";i:4724;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.4;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.4;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.4;s:26:\"original_price_without_tax\";d:0.4;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.4;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"0.4\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"0.4\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.40\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1580:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_b87fca2ab5fc17bbace0c3644b72b24d\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:79:\"Лента (0,6см) капроновая (отрез 5м) синяя &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:79:\"Лента (0,6см) капроновая (отрез 5м) синяя &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:79:\"Лента (0,6см) капроновая (отрез 5м) синяя &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763600860'),
('7403947', '76990d43c183b18bd333c6c0c0fef10f', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"777a8921b9777a57a060d94c236b624c\";a:12:{s:3:\"key\";s:32:\"777a8921b9777a57a060d94c236b624c\";s:10:\"product_id\";i:36364;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:2.2;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:2.2;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:2.5;s:26:\"original_price_without_tax\";d:2.5;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:2.2;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"2.2\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"2.2\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"2.20\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1478:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_47cbe25f7accdf2dd1a8d65c943ff0d3\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:45:\"Шаблон \"корона 6\" №76 &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:45:\"Шаблон \"корона 6\" №76 &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:45:\"Шаблон \"корона 6\" №76 &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763602401'),
('7403948', '73582e9da9f6a752edef2b95326eb8a4', 'a:14:{s:4:\"cart\";s:1059:\"a:1:{s:32:\"99916d4a8f5c6aa065eecaba07e202c0\";a:12:{s:3:\"key\";s:32:\"99916d4a8f5c6aa065eecaba07e202c0\";s:10:\"product_id\";i:57224;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.21600000000000003;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.21600000000000003;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.27;s:26:\"original_price_without_tax\";d:0.27;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:1:{i:4;a:1:{i:0;d:0.05399999999999999;}}s:8:\"discount\";a:1:{i:4;a:1:{i:0;d:0.05399999999999999;}}s:9:\"new_price\";d:0.21600000000000003;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.22\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.22\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.22\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1544:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_dcb087541dcc81c416dffc364c5ffd48\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:67:\"Термонаклейка (2-3см) \"подарочек\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:67:\"Термонаклейка (2-3см) \"подарочек\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:67:\"Термонаклейка (2-3см) \"подарочек\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763602498'),
('7403949', 'ba0ab1e4d31fa13427fedac592957cc2', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"1e015d3b4a83e478faf3a3693cfce279\";a:12:{s:3:\"key\";s:32:\"1e015d3b4a83e478faf3a3693cfce279\";s:10:\"product_id\";i:34420;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.9;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.9;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.1;s:26:\"original_price_without_tax\";d:1.1;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.9;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"0.9\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"0.9\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.90\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1583:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_a945051fc0fb3a4216963eb169564313\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:80:\"Фетр (1мм) светло-розовый (20×30см) мягкий &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:80:\"Фетр (1мм) светло-розовый (20×30см) мягкий &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:80:\"Фетр (1мм) светло-розовый (20×30см) мягкий &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763602583'),
('7403950', '7a7d9953ab3e31411b1338b577a1cca0', 'a:14:{s:4:\"cart\";s:942:\"a:1:{s:32:\"8cc8be7f9b849fcb595f6a1b0971edfd\";a:12:{s:3:\"key\";s:32:\"8cc8be7f9b849fcb595f6a1b0971edfd\";s:10:\"product_id\";i:57325;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.65;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.65;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.65;s:26:\"original_price_without_tax\";d:0.65;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.65;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.65\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.65\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.65\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1592:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_7a67f393eaafc50de08b0e2b8d9dcf94\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:83:\"Лента (3,5см) парчовая «сетка» фиолетовая &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:83:\"Лента (3,5см) парчовая «сетка» фиолетовая &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:83:\"Лента (3,5см) парчовая «сетка» фиолетовая &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763603683'),
('7403951', '78b84a355cf700031ef7d9c34bd392ce', 'a:14:{s:4:\"cart\";s:1089:\"a:1:{s:32:\"efbdafbc8adea6e9920633bc8ceea86e\";a:12:{s:3:\"key\";s:32:\"efbdafbc8adea6e9920633bc8ceea86e\";s:10:\"product_id\";i:53223;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.21600000000000003;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.21600000000000003;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:4:{s:14:\"original_price\";d:0.27;s:26:\"original_price_without_tax\";d:0.27;s:18:\"original_price_tax\";d:0;s:20:\"initial_custom_price\";N;}s:7:\"history\";a:1:{i:4;a:1:{i:0;d:0.05399999999999999;}}s:8:\"discount\";a:1:{i:4;a:1:{i:0;d:0.05399999999999999;}}s:9:\"new_price\";d:0.21600000000000003;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.22\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.22\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.22\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";s:6:\"a:0:{}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1604:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_7553af75090f4bc41407851c25c0e6e6\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:87:\"Термонаклейки (2-3см) \"мамина ягодка (вишня)\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:87:\"Термонаклейки (2-3см) \"мамина ягодка (вишня)\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:87:\"Термонаклейки (2-3см) \"мамина ягодка (вишня)\" &times; 1\";}}}}\";}', '1763604776'),
('7403953', 'a78ff01dc7c38ce1bcb16463e4bca9e8', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"9559390f7fa2e852446f2b8cecfb7dc1\";a:12:{s:3:\"key\";s:32:\"9559390f7fa2e852446f2b8cecfb7dc1\";s:10:\"product_id\";i:98514;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:4.1;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:4.1;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:4.1;s:26:\"original_price_without_tax\";d:4.1;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:4.1;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"4.1\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"4.1\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"4.10\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1463:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_a81ac2442b22da2b0b8ecdb3677746fd\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:40:\"Набор капрона №6 &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:40:\"Набор капрона №6 &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:40:\"Набор капрона №6 &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763604908'),
('7403954', '6cc0e6ab7cf8f1b156d7f28ad8b88e09', 'a:14:{s:4:\"cart\";s:941:\"a:1:{s:32:\"f016e59c7ad8b1d72903bb1aa5720d53\";a:12:{s:3:\"key\";s:32:\"f016e59c7ad8b1d72903bb1aa5720d53\";s:10:\"product_id\";i:1394;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.14;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.14;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.14;s:26:\"original_price_without_tax\";d:0.14;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.14;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.14\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.14\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.14\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";s:350:\"a:1:{s:7:\"success\";a:1:{i:0;a:2:{s:6:\"notice\";s:275:\"<a href=\"https://businki-lentochki.by/cart/\" tabindex=\"1\" class=\"button wc-forward\">Просмотр корзины</a> Вы отложили &ldquo;Двухцветная синельная проволока (30см) чёрно-белая&rdquo; в свою корзину.\";s:4:\"data\";a:0:{}}}}\";s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1649:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_80c7b3793715e586a1fd3f640f0f4506\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:101:\"Двухцветная синельная проволока (30см) чёрно-белая &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:101:\"Двухцветная синельная проволока (30см) чёрно-белая &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:101:\"Двухцветная синельная проволока (30см) чёрно-белая &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763605070'),
('7403955', '62546fe7e357e4fe53bdd70de80502a1', 'a:14:{s:4:\"cart\";s:1059:\"a:1:{s:32:\"71a04561e43c4ba6db6663c142598f96\";a:12:{s:3:\"key\";s:32:\"71a04561e43c4ba6db6663c142598f96\";s:10:\"product_id\";i:57763;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.21600000000000003;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.21600000000000003;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.27;s:26:\"original_price_without_tax\";d:0.27;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:1:{i:4;a:1:{i:0;d:0.05399999999999999;}}s:8:\"discount\";a:1:{i:4;a:1:{i:0;d:0.05399999999999999;}}s:9:\"new_price\";d:0.21600000000000003;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.22\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.22\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.22\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1553:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_115e0293b6d760a9374bfabe30272e14\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:70:\"Термонаклейка (3см) \"мамина зайка\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:70:\"Термонаклейка (3см) \"мамина зайка\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:70:\"Термонаклейка (3см) \"мамина зайка\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763605091'),
('7403956', '3536bb68d829759cf76657c735cbb64f', 'a:14:{s:4:\"cart\";s:1027:\"a:1:{s:32:\"66a903fcf84e2a0b4a7a606650f6b9ac\";a:12:{s:3:\"key\";s:32:\"66a903fcf84e2a0b4a7a606650f6b9ac\";s:10:\"product_id\";i:63774;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.08;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.08;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.1;s:26:\"original_price_without_tax\";d:0.1;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:1:{i:4;a:1:{i:0;d:0.01999999999999999;}}s:8:\"discount\";a:1:{i:4;a:1:{i:0;d:0.01999999999999999;}}s:9:\"new_price\";d:0.08000000000000002;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.08\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.08\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.08\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1505:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_b183581222557b31b5e752affbd9ff8e\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:54:\"Наклейки (3,5см) \"Hand made\" №19 &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:54:\"Наклейки (3,5см) \"Hand made\" №19 &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:54:\"Наклейки (3,5см) \"Hand made\" №19 &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763605094'),
('7403957', '9008321f9b109e320c6212b4da4b3c4b', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"28d50693bf6468465b80ff533f183d6c\";a:12:{s:3:\"key\";s:32:\"28d50693bf6468465b80ff533f183d6c\";s:10:\"product_id\";i:17466;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.2;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.2;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.2;s:26:\"original_price_without_tax\";d:1.2;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.2;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.2\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.2\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.20\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1460:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_7a6ad116041c24e6dfe6d002a6adfd1b\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:39:\"Карелиус жёлтый &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:39:\"Карелиус жёлтый &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:39:\"Карелиус жёлтый &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763605321'),
('7403958', '7d303aadcf3ce7abff6c24bf413e02f8', 'a:14:{s:4:\"cart\";s:941:\"a:1:{s:32:\"729c68884bd359ade15d5f163166738a\";a:12:{s:3:\"key\";s:32:\"729c68884bd359ade15d5f163166738a\";s:10:\"product_id\";i:1484;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.36;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.36;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.36;s:26:\"original_price_without_tax\";d:0.36;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.36;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.36\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.36\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.36\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1691:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_1816df5bc6f176ed7b3926bc659eac8d\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:115:\"Лента (5см) бумажная водонепроницаемая красная с рисунком &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:115:\"Лента (5см) бумажная водонепроницаемая красная с рисунком &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:115:\"Лента (5см) бумажная водонепроницаемая красная с рисунком &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763605511'),
('7403959', '98a5ec1171e7b234d1dcb60ed1e5b074', 'a:14:{s:4:\"cart\";s:936:\"a:1:{s:32:\"f4492508850c58446d4784339470a8f6\";a:12:{s:3:\"key\";s:32:\"f4492508850c58446d4784339470a8f6\";s:10:\"product_id\";i:6434;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:5.9;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:5.9;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:5.9;s:26:\"original_price_without_tax\";d:5.9;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:5.9;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"5.9\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"5.9\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"5.90\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1463:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_2606983c3450edbd7e7f62c5fec8a89d\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:40:\"Набор капрона №2 &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:40:\"Набор капрона №2 &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:40:\"Набор капрона №2 &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763605560'),
('7403960', '99dd15f2b1fb2e5790bedee51dcbbe18', 'a:14:{s:4:\"cart\";s:936:\"a:1:{s:32:\"ea1818cbe59c23b20f1a10a8aa083a82\";a:12:{s:3:\"key\";s:32:\"ea1818cbe59c23b20f1a10a8aa083a82\";s:10:\"product_id\";i:6001;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:4.9;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:4.9;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:4.9;s:26:\"original_price_without_tax\";d:4.9;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:4.9;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"4.9\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"4.9\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"4.90\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1475:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_431a09e002512e132a443c272551cf40\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:44:\"Мандарин (3см) (10 шт) &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:44:\"Мандарин (3см) (10 шт) &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:44:\"Мандарин (3см) (10 шт) &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763607234'),
('7403961', '3d5c73f75500e5ff69f2bcc04ff89ea1', 'a:14:{s:4:\"cart\";s:2904:\"a:3:{s:32:\"66e96398da90a8d37c3c67d6e136fb03\";a:12:{s:3:\"key\";s:32:\"66e96398da90a8d37c3c67d6e136fb03\";s:10:\"product_id\";i:23833;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.45;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.45;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:4:{s:14:\"original_price\";d:0.45;s:26:\"original_price_without_tax\";d:0.45;s:18:\"original_price_tax\";d:0;s:20:\"initial_custom_price\";N;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.45;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}s:32:\"8474b8609e772af467ac0fc4acad4dd4\";a:12:{s:3:\"key\";s:32:\"8474b8609e772af467ac0fc4acad4dd4\";s:10:\"product_id\";i:24031;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.45;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.45;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:4:{s:14:\"original_price\";d:0.45;s:26:\"original_price_without_tax\";d:0.45;s:18:\"original_price_tax\";d:0;s:20:\"initial_custom_price\";N;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.45;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}s:32:\"b7c341015338340fc8cc5c21e0473579\";a:12:{s:3:\"key\";s:32:\"b7c341015338340fc8cc5c21e0473579\";s:10:\"product_id\";i:30120;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.45;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.45;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:4:{s:14:\"original_price\";d:0.45;s:26:\"original_price_without_tax\";d:0.45;s:18:\"original_price_tax\";d:0;s:20:\"initial_custom_price\";N;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.45;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"1.35\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"1.35\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.35\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";s:6:\"a:0:{}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:2093:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_45d6d6f74f66b0b62d396add4be315fa\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:249:\"Лента (2,5см) парчовая «сетка» золотистая &times; 1, Лента (2,5см) парчовая «сетка» серебристая &times; 1, Лента (2,5см) парчовая «сетка» красная &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:249:\"Лента (2,5см) парчовая «сетка» золотистая &times; 1, Лента (2,5см) парчовая «сетка» серебристая &times; 1, Лента (2,5см) парчовая «сетка» красная &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:249:\"Лента (2,5см) парчовая «сетка» золотистая &times; 1, Лента (2,5см) парчовая «сетка» серебристая &times; 1, Лента (2,5см) парчовая «сетка» красная &times; 1\";}}}}\";}', '1763607651'),
('7403964', '35b42ac402d21c05592ea11da7d4cfff', 'a:14:{s:4:\"cart\";s:936:\"a:1:{s:32:\"0b9b6d6d154e98ce34b3f2e4ef76eae9\";a:12:{s:3:\"key\";s:32:\"0b9b6d6d154e98ce34b3f2e4ef76eae9\";s:10:\"product_id\";i:9512;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.3;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.3;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.3;s:26:\"original_price_without_tax\";d:1.3;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.3;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.3\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.3\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.30\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1580:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_ca3ae4d5b091cd95c42136f35abe1e70\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:79:\"Лента (4см) декоративная \"цветок\" белая &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:79:\"Лента (4см) декоративная \"цветок\" белая &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:79:\"Лента (4см) декоративная \"цветок\" белая &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763607662'),
('7403969', '2696841f9fdd96c5b9cdf92a5882ff02', 'a:14:{s:4:\"cart\";s:1029:\"a:1:{s:32:\"a2e624045eb47b256fca7ac2d1e7ff1f\";a:12:{s:3:\"key\";s:32:\"a2e624045eb47b256fca7ac2d1e7ff1f\";s:10:\"product_id\";i:66786;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.44;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.44;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.55;s:26:\"original_price_without_tax\";d:0.55;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:1:{i:4;a:1:{i:0;d:0.10999999999999999;}}s:8:\"discount\";a:1:{i:4;a:1:{i:0;d:0.10999999999999999;}}s:9:\"new_price\";d:0.44000000000000006;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.44\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.44\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.44\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1673:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_ff4a0c8a63376a88308ac703ce5600c7\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:109:\"Термотрансферная наклейка (15×30мм) \"Наш ангел\" \"серебро\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:109:\"Термотрансферная наклейка (15×30мм) \"Наш ангел\" \"серебро\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:109:\"Термотрансферная наклейка (15×30мм) \"Наш ангел\" \"серебро\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763607715'),
('7403970', 'c47b49902ba7e053d2d6deb9ae207a28', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"f36575207c38c27e3cba84563b05c9f0\";a:12:{s:3:\"key\";s:32:\"f36575207c38c27e3cba84563b05c9f0\";s:10:\"product_id\";i:65820;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:6.5;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:6.5;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:6.5;s:26:\"original_price_without_tax\";d:6.5;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:6.5;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"6.5\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"6.5\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"6.50\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1628:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_2debf548fffb27b1696869d786be995a\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:95:\"Набор лент (4 см) репсовых №2 (5 цветов по 2 метра) &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:95:\"Набор лент (4 см) репсовых №2 (5 цветов по 2 метра) &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:95:\"Набор лент (4 см) репсовых №2 (5 цветов по 2 метра) &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763607789'),
('7403971', 'de1f98a4db2bb8a1614d4e37afb0b697', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"865e5be9fa1ea5a7681f8fa5def5b280\";a:12:{s:3:\"key\";s:32:\"865e5be9fa1ea5a7681f8fa5def5b280\";s:10:\"product_id\";i:37739;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:5.4;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:5.4;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:5.4;s:26:\"original_price_without_tax\";d:5.4;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:5.4;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"5.4\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"5.4\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"5.40\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1697:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_7532cbf905fbe5f93cac9403041d297a\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:117:\"Заготовка (Ø20см) деревянная \"подставка под горячее \"клевер\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:117:\"Заготовка (Ø20см) деревянная \"подставка под горячее \"клевер\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:117:\"Заготовка (Ø20см) деревянная \"подставка под горячее \"клевер\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763607860'),
('7403972', '1e992291c4b8a6f3a37d0ec4d506226e', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"812bfa6d29aa3c52e84258e9c2ab3d59\";a:12:{s:3:\"key\";s:32:\"812bfa6d29aa3c52e84258e9c2ab3d59\";s:10:\"product_id\";i:16432;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.4;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.4;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.4;s:26:\"original_price_without_tax\";d:0.4;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.4;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"0.4\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"0.4\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.40\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1598:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_9e7625c1abfd420dcc807df490e33bd2\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:85:\"Кабошон (17мм) \"жёлтая вишенка с точечками\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:85:\"Кабошон (17мм) \"жёлтая вишенка с точечками\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:85:\"Кабошон (17мм) \"жёлтая вишенка с точечками\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763607907'),
('7403973', '3ef0a93eea9f85aee1214585e71bb581', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"300058cc7d509b418f18870314eb92ac\";a:12:{s:3:\"key\";s:32:\"300058cc7d509b418f18870314eb92ac\";s:10:\"product_id\";i:17477;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.2;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.2;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.2;s:26:\"original_price_without_tax\";d:1.2;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.2;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.2\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.2\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.20\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1466:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_2e582b440e958b75bdc8f59c5048b333\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:41:\"Карелиус красный &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:41:\"Карелиус красный &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:41:\"Карелиус красный &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763609718'),
('7403974', '82d23f6067b2793d2f71dc340d12cd18', 'a:14:{s:4:\"cart\";s:942:\"a:1:{s:32:\"1dd5a4016c624ef51f0542d4ae60e281\";a:12:{s:3:\"key\";s:32:\"1dd5a4016c624ef51f0542d4ae60e281\";s:10:\"product_id\";i:12686;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.25;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.25;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.25;s:26:\"original_price_without_tax\";d:0.25;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.25;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.25\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.25\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.25\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1469:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_20041830c89cd16dd25a4082c14b75fd\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:42:\"Разделитель (3,5см) &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:42:\"Разделитель (3,5см) &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:42:\"Разделитель (3,5см) &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763609893'),
('7403975', 'dfe109bd136b575387e743411467c25a', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"ccd986d2de4c75133c049e26005b3dbc\";a:12:{s:3:\"key\";s:32:\"ccd986d2de4c75133c049e26005b3dbc\";s:10:\"product_id\";i:34436;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:6.9;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:6.9;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:6.9;s:26:\"original_price_without_tax\";d:6.9;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:6.9;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"6.9\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"6.9\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"6.90\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1682:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_9774b89aece99acd85f28d2c2cf03f42\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:112:\"Пенопластовая заготовка (30×34см) \"счастливые молодожёны\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:112:\"Пенопластовая заготовка (30×34см) \"счастливые молодожёны\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:112:\"Пенопластовая заготовка (30×34см) \"счастливые молодожёны\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763610200');
/**ABDB**/INSERT INTO `#__woocommerce_sessions`  VALUES 
('7403976', 'c28fb9b2ce314323086a8f90e0d6574c', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"43a72b87ab20bbf7aa1759b547004c84\";a:12:{s:3:\"key\";s:32:\"43a72b87ab20bbf7aa1759b547004c84\";s:10:\"product_id\";i:93029;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.3;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.3;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.5;s:26:\"original_price_without_tax\";d:0.5;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.3;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"0.3\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"0.3\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.30\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1640:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_dd424d0e96f08623e7a4747caa1a7818\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:99:\"Термонаклейка (4×2,5см) шаблон для броши «губы №39» &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:99:\"Термонаклейка (4×2,5см) шаблон для броши «губы №39» &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:99:\"Термонаклейка (4×2,5см) шаблон для броши «губы №39» &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763610370'),
('7403977', '285357ad7c3fadd8d7ab99d9b0ef7691', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"b5628fed964d280aab18f11d1afcd3fe\";a:12:{s:3:\"key\";s:32:\"b5628fed964d280aab18f11d1afcd3fe\";s:10:\"product_id\";i:27145;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.5;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.5;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.5;s:26:\"original_price_without_tax\";d:0.5;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.5;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"0.5\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"0.5\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.50\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1517:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_ba3243ec5cf6deb0b1d010d026b05e5f\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:58:\"Полубусины (10мм) \"болотные\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:58:\"Полубусины (10мм) \"болотные\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:58:\"Полубусины (10мм) \"болотные\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763610386'),
('7403978', 'ab8afd01d83b7bcd06435126036d6ec9', 'a:14:{s:4:\"cart\";s:942:\"a:1:{s:32:\"ec0ce4611e7360d72c3a4f4504e63228\";a:12:{s:3:\"key\";s:32:\"ec0ce4611e7360d72c3a4f4504e63228\";s:10:\"product_id\";i:57384;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:5.29;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:5.29;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:5.29;s:26:\"original_price_without_tax\";d:5.29;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:5.29;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"5.29\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"5.29\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"5.29\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1589:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_2c59b56865b572bb4e44b72696920252\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:82:\"Молд \"лист аквилегии (водосбор) большой\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:82:\"Молд \"лист аквилегии (водосбор) большой\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:82:\"Молд \"лист аквилегии (водосбор) большой\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763610882'),
('7403979', '78b2f1357a7c9d410f8b7a79db928da4', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"06e988586ba81f5bc26116d52b35edb9\";a:12:{s:3:\"key\";s:32:\"06e988586ba81f5bc26116d52b35edb9\";s:10:\"product_id\";i:68648;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.1;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.1;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.1;s:26:\"original_price_without_tax\";d:1.1;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.1;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.1\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.1\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.10\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1577:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_21df53453b8a3d3e408650b4cce9bdd7\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:78:\"Кабошоны (5гр) декоративные \"сердечки\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:78:\"Кабошоны (5гр) декоративные \"сердечки\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:78:\"Кабошоны (5гр) декоративные \"сердечки\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763610927'),
('7403980', '8c984dd06ed029adb0c7378746e8dea7', 'a:14:{s:4:\"cart\";s:927:\"a:1:{s:32:\"8304cbd3c5a7073e27d494893bc86ef0\";a:12:{s:3:\"key\";s:32:\"8304cbd3c5a7073e27d494893bc86ef0\";s:10:\"product_id\";i:52190;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:3;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:3;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:4;s:26:\"original_price_without_tax\";d:4;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:3;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:390:\"a:15:{s:8:\"subtotal\";s:1:\"3\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:1:\"3\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"3.00\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1535:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_1e39eaad933d5e35222db3586569ffe6\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:64:\"Фетр (1мм) терракотовый (85×50см) &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:64:\"Фетр (1мм) терракотовый (85×50см) &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:64:\"Фетр (1мм) терракотовый (85×50см) &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763610969'),
('7403981', '0c47b64d9a4e54cba69cbbb42479a3a3', 'a:14:{s:4:\"cart\";s:942:\"a:1:{s:32:\"4928e46bcbe527ef51745fdd83d50cd7\";a:12:{s:3:\"key\";s:32:\"4928e46bcbe527ef51745fdd83d50cd7\";s:10:\"product_id\";i:60045;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.25;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.25;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.25;s:26:\"original_price_without_tax\";d:1.25;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.25;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"1.25\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"1.25\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.25\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";s:365:\"a:1:{s:7:\"success\";a:1:{i:0;a:2:{s:6:\"notice\";s:290:\"<a href=\"https://businki-lentochki.by/cart/\" tabindex=\"1\" class=\"button wc-forward\">Просмотр корзины</a> Вы отложили &ldquo;Патч (53×45мм) силиконовый с пайетками &#171;зайчик красный&#187;&rdquo; в свою корзину.\";s:4:\"data\";a:0:{}}}}\";s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1664:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_92b30c29617e82ba9eb28cab69dd5a99\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:106:\"Патч (53×45мм) силиконовый с пайетками \"зайчик красный\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:106:\"Патч (53×45мм) силиконовый с пайетками \"зайчик красный\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:106:\"Патч (53×45мм) силиконовый с пайетками \"зайчик красный\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763611587'),
('7403982', 'cbdc1c1e577c74d836828f2120e224c9', 'a:14:{s:4:\"cart\";s:967:\"a:1:{s:32:\"28c634381653ecb8ffcf146cd8caf34e\";a:12:{s:3:\"key\";s:32:\"28c634381653ecb8ffcf146cd8caf34e\";s:10:\"product_id\";i:41426;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:7.1;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:7.1;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:4:{s:14:\"original_price\";d:7.1;s:26:\"original_price_without_tax\";d:7.1;s:18:\"original_price_tax\";d:0;s:20:\"initial_custom_price\";N;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:7.1;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"7.1\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"7.1\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"7.10\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";s:6:\"a:0:{}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1646:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_f4d0fe68c2f850add8becb6a761df19a\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:100:\"Шерсть для валяния тонкая \"зелёное яблоко\" \"Гамма\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:100:\"Шерсть для валяния тонкая \"зелёное яблоко\" \"Гамма\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:100:\"Шерсть для валяния тонкая \"зелёное яблоко\" \"Гамма\" &times; 1\";}}}}\";}', '1763611885'),
('7403984', '518a91c1b0af09b02bd79dc89aecb830', 'a:14:{s:4:\"cart\";s:940:\"a:1:{s:32:\"0de3a9839b79ebed42f95f1e30d4e951\";a:12:{s:3:\"key\";s:32:\"0de3a9839b79ebed42f95f1e30d4e951\";s:10:\"product_id\";i:70180;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.45;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.45;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.6;s:26:\"original_price_without_tax\";d:0.6;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.45;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.45\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.45\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.45\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1523:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_0986f1f63f19b945391bb908da589365\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:60:\"Патч (5см) сборный \"брокколи\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:60:\"Патч (5см) сборный \"брокколи\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:60:\"Патч (5см) сборный \"брокколи\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763611933'),
('7403985', 'f5bf648c25faf85401194c16ba278aa4', 'a:14:{s:4:\"cart\";s:927:\"a:1:{s:32:\"26324d8e2cc1957b8e581568a089a51c\";a:12:{s:3:\"key\";s:32:\"26324d8e2cc1957b8e581568a089a51c\";s:10:\"product_id\";i:26473;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:4;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:4;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:4;s:26:\"original_price_without_tax\";d:4;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:4;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:390:\"a:15:{s:8:\"subtotal\";s:1:\"4\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:1:\"4\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"4.00\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1652:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_33b0f51aff510b6484c8b42abbb16b7b\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:102:\"Набор салатовых сердечек (3/9мм) на леске (4×1,3 метра) &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:102:\"Набор салатовых сердечек (3/9мм) на леске (4×1,3 метра) &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:102:\"Набор салатовых сердечек (3/9мм) на леске (4×1,3 метра) &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763612368'),
('7403986', 'cfe04b48348a06926eba2718afcf6a3d', 'a:14:{s:4:\"cart\";s:936:\"a:1:{s:32:\"0342c9a7b54450830e9727b98f8e3cb7\";a:12:{s:3:\"key\";s:32:\"0342c9a7b54450830e9727b98f8e3cb7\";s:10:\"product_id\";i:5011;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:3.9;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:3.9;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:3.9;s:26:\"original_price_without_tax\";d:3.9;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:3.9;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"3.9\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"3.9\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"3.90\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1538:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_b9a3ff06ca43b280f4537587ccce42cb\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:65:\"Набор крышек металлических №4 &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:65:\"Набор крышек металлических №4 &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:65:\"Набор крышек металлических №4 &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763612504'),
('7403987', '90c71f50f2a33b59cb8d823734f52402', 'a:14:{s:4:\"cart\";s:927:\"a:1:{s:32:\"9a9507ccbb6be14e614c0c61cb485c83\";a:12:{s:3:\"key\";s:32:\"9a9507ccbb6be14e614c0c61cb485c83\";s:10:\"product_id\";i:20562;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1;s:26:\"original_price_without_tax\";d:1;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:390:\"a:15:{s:8:\"subtotal\";s:1:\"1\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:1:\"1\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.00\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1628:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_e258617c9403f1c75f7bd587559610c2\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:95:\"Бисер (20 гр) 12/0 прозрачный с розовым отверстием &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:95:\"Бисер (20 гр) 12/0 прозрачный с розовым отверстием &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:95:\"Бисер (20 гр) 12/0 прозрачный с розовым отверстием &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763612803'),
('7403988', '6b62583c6039afad094352f95152bd34', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"871ee402e7a9a1cc25c02e0e0b1bb08c\";a:12:{s:3:\"key\";s:32:\"871ee402e7a9a1cc25c02e0e0b1bb08c\";s:10:\"product_id\";i:19558;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.2;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.2;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.2;s:26:\"original_price_without_tax\";d:0.2;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.2;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"0.2\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"0.2\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.20\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1511:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_6b35ee74fcd942ed8be3dfdc2cc872ca\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:56:\"Основа (2,5см) \"сито\" золото &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:56:\"Основа (2,5см) \"сито\" золото &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:56:\"Основа (2,5см) \"сито\" золото &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763612872'),
('7403989', 'd5cc49f5f66e270b05ba6f65eec9b7f9', 'a:14:{s:4:\"cart\";s:942:\"a:1:{s:32:\"56dfcaf2665b93ddeb01dfde7981c832\";a:12:{s:3:\"key\";s:32:\"56dfcaf2665b93ddeb01dfde7981c832\";s:10:\"product_id\";i:37751;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:3.85;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:3.85;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:3.85;s:26:\"original_price_without_tax\";d:3.85;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:3.85;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"3.85\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"3.85\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"3.85\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1535:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_2fcc64a06109f88715dcb2d872e3a59e\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:64:\"Салфетница (15×7×7см) \"полукруг\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:64:\"Салфетница (15×7×7см) \"полукруг\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:64:\"Салфетница (15×7×7см) \"полукруг\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763613038'),
('7403990', '41bee666eb82f25d28f9a8445ad8d9e2', 'a:14:{s:4:\"cart\";s:942:\"a:1:{s:32:\"9f96f0c23a6a55dbd2e9427729e24266\";a:12:{s:3:\"key\";s:32:\"9f96f0c23a6a55dbd2e9427729e24266\";s:10:\"product_id\";i:68900;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.25;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.25;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.25;s:26:\"original_price_without_tax\";d:0.25;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.25;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.25\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.25\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.25\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1475:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_cbba75b27234fc91766da6a03c98731c\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:44:\"Открытка (7×10см) №43 &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:44:\"Открытка (7×10см) №43 &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:44:\"Открытка (7×10см) №43 &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763613475'),
('7403991', 'b42489ec972840bea566862cb61c592f', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"a658d23016fb87f4536849e04851921d\";a:12:{s:3:\"key\";s:32:\"a658d23016fb87f4536849e04851921d\";s:10:\"product_id\";i:38261;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.8;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.8;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.8;s:26:\"original_price_without_tax\";d:0.8;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.8;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"0.8\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"0.8\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.80\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1514:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_c002b7423d44d68668080f233b4c6dd6\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:57:\"Подвеска (6см) \"поздравляю\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:57:\"Подвеска (6см) \"поздравляю\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:57:\"Подвеска (6см) \"поздравляю\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763613832'),
('7403992', 'a3ce975b0aa5ac86166087337105cc86', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"3116e950b3286184e6057e9ce5e34ea3\";a:12:{s:3:\"key\";s:32:\"3116e950b3286184e6057e9ce5e34ea3\";s:10:\"product_id\";i:83366;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:7.9;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:7.9;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:7.9;s:26:\"original_price_without_tax\";d:7.9;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:7.9;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"7.9\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"7.9\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"7.90\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1667:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_6d4b3d5b00a593f056d6a6a8aeb6b6dc\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:107:\"Набор кабошонов пластиковых (5 дизайнов по 2 штуки) №23 &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:107:\"Набор кабошонов пластиковых (5 дизайнов по 2 штуки) №23 &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:107:\"Набор кабошонов пластиковых (5 дизайнов по 2 штуки) №23 &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763613872'),
('7403993', '63b7409a8493ec28876ef07ccd6b106e', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"640f83ae6bb1f036f45e453ceba79db9\";a:12:{s:3:\"key\";s:32:\"640f83ae6bb1f036f45e453ceba79db9\";s:10:\"product_id\";i:83371;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:7.9;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:7.9;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:7.9;s:26:\"original_price_without_tax\";d:7.9;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:7.9;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"7.9\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"7.9\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"7.90\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1667:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_3e78f1d0bfff80e194e9df488e76a49a\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:107:\"Набор кабошонов пластиковых (5 дизайнов по 2 штуки) №22 &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:107:\"Набор кабошонов пластиковых (5 дизайнов по 2 штуки) №22 &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:107:\"Набор кабошонов пластиковых (5 дизайнов по 2 штуки) №22 &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763613907'),
('7403994', '827120c88970883d3403cb964fb6cda9', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"7b1223235e9b545dffd56c4cac714b41\";a:12:{s:3:\"key\";s:32:\"7b1223235e9b545dffd56c4cac714b41\";s:10:\"product_id\";i:18493;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.2;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.2;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.5;s:26:\"original_price_without_tax\";d:1.5;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.2;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.2\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.2\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.20\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1469:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_cbbec03f59ecf81d2aa5df8774a0d439\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:42:\"Фатин (50см) чёрный &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:42:\"Фатин (50см) чёрный &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:42:\"Фатин (50см) чёрный &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763614014'),
('7403995', '009f371c5c412936fc35f43f401ffeab', 'a:14:{s:4:\"cart\";s:942:\"a:1:{s:32:\"1fe4e21310595785d4ead1574e0ed69d\";a:12:{s:3:\"key\";s:32:\"1fe4e21310595785d4ead1574e0ed69d\";s:10:\"product_id\";i:77443;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.22;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.22;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.44;s:26:\"original_price_without_tax\";d:0.44;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.22;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.22\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.22\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.22\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1532:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_4fb5c722bbe5a76f6bd675a06d4ca7dc\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:63:\"Подвеска (26×20мм) \"best friends пазл\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:63:\"Подвеска (26×20мм) \"best friends пазл\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:63:\"Подвеска (26×20мм) \"best friends пазл\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763614158'),
('7403996', 'c46d3a87b131e3735863d4e9b3ee60b3', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"a7a0a1f4201d3a346c365914c1ebb3bd\";a:12:{s:3:\"key\";s:32:\"a7a0a1f4201d3a346c365914c1ebb3bd\";s:10:\"product_id\";i:52246;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.5;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.5;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.9;s:26:\"original_price_without_tax\";d:1.9;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.5;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.5\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.5\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.50\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1532:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_b541fc5a6717509556af6de169a829e0\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:63:\"Фетр (2мм) ярко-розовый (20×30см) &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:63:\"Фетр (2мм) ярко-розовый (20×30см) &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:63:\"Фетр (2мм) ярко-розовый (20×30см) &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763614877'),
('7403997', '9557e09f969dd15192a954b9cb0d7a3c', 'a:14:{s:4:\"cart\";s:942:\"a:1:{s:32:\"1d39fd4773e27bb1badce133b2cec2ac\";a:12:{s:3:\"key\";s:32:\"1d39fd4773e27bb1badce133b2cec2ac\";s:10:\"product_id\";i:51788;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.29;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.29;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.29;s:26:\"original_price_without_tax\";d:0.29;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.29;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.29\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.29\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.29\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1538:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_5ace49e84ebb78420eb5df167c5c334d\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:65:\"Подвески (20×13мм) «сова» бронза &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:65:\"Подвески (20×13мм) «сова» бронза &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:65:\"Подвески (20×13мм) «сова» бронза &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763615426'),
('7403998', '7b43fb2afef8984e7224bef67f058b6e', 'a:14:{s:4:\"cart\";s:1059:\"a:1:{s:32:\"33880528245ea2845dc447bd36ebc547\";a:12:{s:3:\"key\";s:32:\"33880528245ea2845dc447bd36ebc547\";s:10:\"product_id\";i:34594;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.21600000000000003;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.21600000000000003;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.27;s:26:\"original_price_without_tax\";d:0.27;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:1:{i:4;a:1:{i:0;d:0.05399999999999999;}}s:8:\"discount\";a:1:{i:4;a:1:{i:0;d:0.05399999999999999;}}s:9:\"new_price\";d:0.21600000000000003;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.22\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.22\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.22\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1553:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_55eeaf732f5daab0dd4172c0b95c9847\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:70:\"Термонаклейки (2-3см) \"мамин котик\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:70:\"Термонаклейки (2-3см) \"мамин котик\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:70:\"Термонаклейки (2-3см) \"мамин котик\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763615760'),
('7403999', '1e7ef82baac6dcb9f4cd6e7093c95979', 'a:14:{s:4:\"cart\";s:1027:\"a:1:{s:32:\"98283a0372595f1c1ef06c23ec31c1f6\";a:12:{s:3:\"key\";s:32:\"98283a0372595f1c1ef06c23ec31c1f6\";s:10:\"product_id\";i:68456;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.08;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.08;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.1;s:26:\"original_price_without_tax\";d:0.1;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:1:{i:4;a:1:{i:0;d:0.01999999999999999;}}s:8:\"discount\";a:1:{i:4;a:1:{i:0;d:0.01999999999999999;}}s:9:\"new_price\";d:0.08000000000000002;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.08\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.08\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.08\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1580:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_ce6e19cbfa447e1b4c6dd67592fa5761\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:79:\"Наклейки (3,5см) «Сделано с любовью» №15 &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:79:\"Наклейки (3,5см) «Сделано с любовью» №15 &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:79:\"Наклейки (3,5см) «Сделано с любовью» №15 &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763615778'),
('7404000', '2feb2e746ed7a545f1ed2af8408311a3', 'a:14:{s:4:\"cart\";s:936:\"a:1:{s:32:\"076023edc9187cf1ac1f1163470e479a\";a:12:{s:3:\"key\";s:32:\"076023edc9187cf1ac1f1163470e479a\";s:10:\"product_id\";i:1583;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.3;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.3;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.8;s:26:\"original_price_without_tax\";d:1.8;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.3;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.3\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.3\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.30\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1667:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_7f624322a0b542e20471069b7ef4c51b\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:107:\"Лента (2,4см) декоративная с орнаментом красно-зеленая &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:107:\"Лента (2,4см) декоративная с орнаментом красно-зеленая &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:107:\"Лента (2,4см) декоративная с орнаментом красно-зеленая &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763616153'),
('7404001', '42d5781621425823d85af3281694c537', 'a:14:{s:4:\"cart\";s:942:\"a:1:{s:32:\"31073475fc4fe0f27c6b876472f0888e\";a:12:{s:3:\"key\";s:32:\"31073475fc4fe0f27c6b876472f0888e\";s:10:\"product_id\";i:25694;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.26;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.26;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.26;s:26:\"original_price_without_tax\";d:1.26;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.26;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"1.26\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"1.26\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.26\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1541:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_64065570f992328bf748dc0ff5cd7c36\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:66:\"Обложка (А4) для учебника (120мкм) &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:66:\"Обложка (А4) для учебника (120мкм) &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:66:\"Обложка (А4) для учебника (120мкм) &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763616200'),
('7404002', '24eaf84c54ff443c666328dea7ec92b9', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"5f2cec9d7c7078209559b2838b427b2f\";a:12:{s:3:\"key\";s:32:\"5f2cec9d7c7078209559b2838b427b2f\";s:10:\"product_id\";i:56879;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:6.2;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:6.2;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:6.2;s:26:\"original_price_without_tax\";d:6.2;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:6.2;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"6.2\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"6.2\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"6.20\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1658:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_dd867815addda0b86fabee136bf4d99e\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:104:\"Тесьма (0,9см) «вьюнчик» с люрексом зелёная (10 метров) &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:104:\"Тесьма (0,9см) «вьюнчик» с люрексом зелёная (10 метров) &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:104:\"Тесьма (0,9см) «вьюнчик» с люрексом зелёная (10 метров) &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763616236'),
('7404003', '0df2c90eaee4e4ef503d89ff615ce0aa', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"4d33696e6c41cca92b4cda58b63fc5f8\";a:12:{s:3:\"key\";s:32:\"4d33696e6c41cca92b4cda58b63fc5f8\";s:10:\"product_id\";i:35198;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.5;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.5;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.5;s:26:\"original_price_without_tax\";d:1.5;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.5;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.5\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.5\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.50\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1535:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_aa08352bfa393287835080f8af545946\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:64:\"Наклейки (30×30см) декоративные &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:64:\"Наклейки (30×30см) декоративные &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:64:\"Наклейки (30×30см) декоративные &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763616457'),
('7404004', 'bfe14cdb148d856edfef88ef749099df', 'a:14:{s:4:\"cart\";s:942:\"a:1:{s:32:\"6fb05b1454c2f985c7bc46994d503703\";a:12:{s:3:\"key\";s:32:\"6fb05b1454c2f985c7bc46994d503703\";s:10:\"product_id\";i:77018;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.55;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.55;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.55;s:26:\"original_price_without_tax\";d:0.55;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.55;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.55\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.55\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.55\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1520:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_56bd0258864a57e81009a9ae4a7184ec\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:59:\"Коннектор (20мм) с сеттингом &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:59:\"Коннектор (20мм) с сеттингом &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:59:\"Коннектор (20мм) с сеттингом &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763616954'),
('7404007', '533a99cd0850052aa4883836f53166f2', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"99fb7da17723eaf0421a7bbb9fada352\";a:12:{s:3:\"key\";s:32:\"99fb7da17723eaf0421a7bbb9fada352\";s:10:\"product_id\";i:24659;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:6.2;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:6.2;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:6.2;s:26:\"original_price_without_tax\";d:6.2;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:6.2;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"6.2\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"6.2\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"6.20\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1604:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_61d7d4e1ce50635b4ffd6d5f9599ff2a\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:87:\"Набор лент (2,5см) атласных №1 (8шт по 3 метра) &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:87:\"Набор лент (2,5см) атласных №1 (8шт по 3 метра) &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:87:\"Набор лент (2,5см) атласных №1 (8шт по 3 метра) &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763616987'),
('7404008', 'd6ccc3f86e9a0b78dd8e8fa8bd955556', 'a:14:{s:4:\"cart\";s:966:\"a:1:{s:32:\"ddeebdeefdb7e7e7a697e1c3e3d8ef54\";a:12:{s:3:\"key\";s:32:\"ddeebdeefdb7e7e7a697e1c3e3d8ef54\";s:10:\"product_id\";i:2411;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.9;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.9;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:4:{s:14:\"original_price\";d:1.9;s:26:\"original_price_without_tax\";d:1.9;s:18:\"original_price_tax\";d:0;s:20:\"initial_custom_price\";N;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.9;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.9\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.9\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.90\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";s:6:\"a:0:{}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1532:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_d37128b98cf3cefc683cc48effd542e9\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:63:\"Кружево (55мм) хлопковое белое &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:63:\"Кружево (55мм) хлопковое белое &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:63:\"Кружево (55мм) хлопковое белое &times; 1\";}}}}\";}', '1763617005'),
('7404011', '16173be012dadd5027db7d9ff7883f79', 'a:14:{s:4:\"cart\";s:1026:\"a:1:{s:32:\"cf58aa5ab2236133d312026ef2405d8c\";a:12:{s:3:\"key\";s:32:\"cf58aa5ab2236133d312026ef2405d8c\";s:10:\"product_id\";i:83491;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.28;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.28;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.6;s:26:\"original_price_without_tax\";d:1.6;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:1:{i:2;a:1:{i:0;d:0.31999999999999984;}}s:8:\"discount\";a:1:{i:2;a:1:{i:0;d:0.31999999999999984;}}s:9:\"new_price\";d:1.2800000000000002;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"1.28\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"1.28\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.28\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1568:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_dab633c3f8f9f05873cee9a25e767a35\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:75:\"Бабочки (4,2×4,2см) №2 на фетре двойные &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:75:\"Бабочки (4,2×4,2см) №2 на фетре двойные &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:75:\"Бабочки (4,2×4,2см) №2 на фетре двойные &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763617017'),
('7404012', 'c574c35556380dd79a997f55e98a3285', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"68e3029766c319b18533206bed2ef83f\";a:12:{s:3:\"key\";s:32:\"68e3029766c319b18533206bed2ef83f\";s:10:\"product_id\";i:16723;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.6;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.6;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.6;s:26:\"original_price_without_tax\";d:1.6;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.6;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.6\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.6\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.60\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1571:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_c9fd22a798c03dc935484c2de2fc82b3\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:76:\"Бабочки (4,0×4,8см) двойные №26 на ткани &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:76:\"Бабочки (4,0×4,8см) двойные №26 на ткани &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:76:\"Бабочки (4,0×4,8см) двойные №26 на ткани &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763617179'),
('7404013', 'abea5dce4fe5aa03e8edd277ffe9c627', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"debccad1c4045756f5b93dcc86a35856\";a:12:{s:3:\"key\";s:32:\"debccad1c4045756f5b93dcc86a35856\";s:10:\"product_id\";i:71392;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:7.9;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:7.9;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:7.9;s:26:\"original_price_without_tax\";d:7.9;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:7.9;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"7.9\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"7.9\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"7.90\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1667:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_6da7f83e6de2c9b0918ae768bf85eea2\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:107:\"Набор кабошонов пластиковых (5 дизайнов по 2 штуки) №39 &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:107:\"Набор кабошонов пластиковых (5 дизайнов по 2 штуки) №39 &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:107:\"Набор кабошонов пластиковых (5 дизайнов по 2 штуки) №39 &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763618039'),
('7404014', '9f8b74531fffcfe478921f1bd17d11fa', 'a:14:{s:4:\"cart\";s:942:\"a:1:{s:32:\"21f3d3617d918301203e6d1515a4c349\";a:12:{s:3:\"key\";s:32:\"21f3d3617d918301203e6d1515a4c349\";s:10:\"product_id\";i:37141;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.75;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.75;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.75;s:26:\"original_price_without_tax\";d:0.75;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.75;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.75\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.75\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.75\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1532:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_a1f54c1100744aa93ec79ea7211ed269\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:63:\"Декупажная карта (21×29,5см) \"love\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:63:\"Декупажная карта (21×29,5см) \"love\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:63:\"Декупажная карта (21×29,5см) \"love\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763618170'),
('7404015', 'a17eed0a44b6c306f36eb2d5674c819d', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"600121245c0201070cbe7a8b9aa93818\";a:12:{s:3:\"key\";s:32:\"600121245c0201070cbe7a8b9aa93818\";s:10:\"product_id\";i:52254;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.5;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.5;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.9;s:26:\"original_price_without_tax\";d:1.9;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.5;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.5\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.5\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.50\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1523:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_d45fb394d3bd45507867702bf996e503\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:60:\"Фетр (2мм) коралловый (20×30см) &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:60:\"Фетр (2мм) коралловый (20×30см) &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:60:\"Фетр (2мм) коралловый (20×30см) &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763618224'),
('7404016', '196a6bcb55403707fe98c1f704f52261', 'a:14:{s:4:\"cart\";s:942:\"a:1:{s:32:\"0bc58258e6f3c040a65fa2bfc9d0c907\";a:12:{s:3:\"key\";s:32:\"0bc58258e6f3c040a65fa2bfc9d0c907\";s:10:\"product_id\";i:34438;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:4.49;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:4.49;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:4.49;s:26:\"original_price_without_tax\";d:4.49;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:4.49;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"4.49\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"4.49\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"4.49\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1649:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_07a54fd8d553edf0aeb659f517f6e3bc\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:101:\"Пенопластовая заготовка (22×16,5см) \"любовь в сердце\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:101:\"Пенопластовая заготовка (22×16,5см) \"любовь в сердце\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:101:\"Пенопластовая заготовка (22×16,5см) \"любовь в сердце\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763618478'),
('7404017', 'b4460845f15740a4154d2016987aa3d7', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"b384acd72f0e46e46c25e23abbebba79\";a:12:{s:3:\"key\";s:32:\"b384acd72f0e46e46c25e23abbebba79\";s:10:\"product_id\";i:98511;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:3.8;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:3.8;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:3.8;s:26:\"original_price_without_tax\";d:3.8;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:3.8;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"3.8\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"3.8\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"3.80\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1463:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_1ff24fd88b30a7b217c7e6dc27352212\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:40:\"Набор капрона №5 &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:40:\"Набор капрона №5 &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:40:\"Набор капрона №5 &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763618713'),
('7404018', '829f45485ee1ad8481c66cf20f8a5330', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"5c4ebfff6c6b8b91dc2a11a56db0b9dd\";a:12:{s:3:\"key\";s:32:\"5c4ebfff6c6b8b91dc2a11a56db0b9dd\";s:10:\"product_id\";i:55607;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.5;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.5;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.5;s:26:\"original_price_without_tax\";d:1.5;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.5;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.5\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.5\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.50\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1604:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_59bcb21df38f9493532917d1da9c4937\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:87:\"Плёнка (60см) \"полоска\" красно-белая матовая &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:87:\"Плёнка (60см) \"полоска\" красно-белая матовая &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:87:\"Плёнка (60см) \"полоска\" красно-белая матовая &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763618754'),
('7404019', 'cb64290874c1518c9498117c942a0e80', 'a:14:{s:4:\"cart\";s:936:\"a:1:{s:32:\"7d0a9bd083154d3d7f429550f7e8fd57\";a:12:{s:3:\"key\";s:32:\"7d0a9bd083154d3d7f429550f7e8fd57\";s:10:\"product_id\";i:7559;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.2;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.2;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.2;s:26:\"original_price_without_tax\";d:1.2;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.2;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.2\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.2\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.20\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1490:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_98fb60d27890f803b320034c1e4e20c9\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:49:\"Полубусины (6мм) \"хаки\" &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:49:\"Полубусины (6мм) \"хаки\" &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:49:\"Полубусины (6мм) \"хаки\" &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763618823'),
('7404020', 'f98aa19160da26492dec20075089e204', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"fd23e2804a17fd514f0fe3d2ceb4351e\";a:12:{s:3:\"key\";s:32:\"fd23e2804a17fd514f0fe3d2ceb4351e\";s:10:\"product_id\";i:58808;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:3.5;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:3.5;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:3.5;s:26:\"original_price_without_tax\";d:3.5;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:3.5;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"3.5\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"3.5\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"3.50\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1571:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_bb52f037729780ee3d4312918fe47170\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:76:\"Бусины (3мм) на леске жёлтые (5 метров) &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:76:\"Бусины (3мм) на леске жёлтые (5 метров) &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:76:\"Бусины (3мм) на леске жёлтые (5 метров) &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763618982'),
('7404021', 'cb60aeeffc9cb48b2c44ee18ccc5a0a3', 'a:14:{s:4:\"cart\";s:942:\"a:1:{s:32:\"e171db9e96bee0061b9c63dd2472df1e\";a:12:{s:3:\"key\";s:32:\"e171db9e96bee0061b9c63dd2472df1e\";s:10:\"product_id\";i:61984;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.25;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.25;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.25;s:26:\"original_price_without_tax\";d:0.25;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.25;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:396:\"a:15:{s:8:\"subtotal\";s:4:\"0.25\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:4:\"0.25\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.25\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1475:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_ca25b36b74e3862be9d5def75dfe274c\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:44:\"Открытка (7×10см) №18 &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:44:\"Открытка (7×10см) №18 &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:44:\"Открытка (7×10см) №18 &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763619171'),
('7404022', '5baa702f60b2d7344f11811336ec8f14', 'a:14:{s:4:\"cart\";s:927:\"a:1:{s:32:\"c42af68f28d516c05caf4ef35a6c4b0c\";a:12:{s:3:\"key\";s:32:\"c42af68f28d516c05caf4ef35a6c4b0c\";s:10:\"product_id\";i:30182;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:4;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:4;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:4;s:26:\"original_price_without_tax\";d:4;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:4;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:390:\"a:15:{s:8:\"subtotal\";s:1:\"4\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:1:\"4\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"4.00\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1637:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_26b7840d796fcef5c8e96c2e68f1b0ea\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:98:\"Набор голубых сердечек (3/9мм) на леске (4×1,3 метра) &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:98:\"Набор голубых сердечек (3/9мм) на леске (4×1,3 метра) &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:98:\"Набор голубых сердечек (3/9мм) на леске (4×1,3 метра) &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763619517'),
('7404023', 'ea80d5ad05b640861f2b6a19f0fbb017', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"ffb430ebdabce62d4d56f4e13cb50fa4\";a:12:{s:3:\"key\";s:32:\"ffb430ebdabce62d4d56f4e13cb50fa4\";s:10:\"product_id\";i:27626;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:0.4;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:0.4;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:0.4;s:26:\"original_price_without_tax\";d:0.4;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:0.4;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"0.4\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"0.4\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"0.40\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1646:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_37b45f3fbee75a685d71cdcb38d3cf00\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:100:\"Лента (0,6см) капроновая (отрез 5м) тёмно-фиолетовая &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:100:\"Лента (0,6см) капроновая (отрез 5м) тёмно-фиолетовая &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:100:\"Лента (0,6см) капроновая (отрез 5м) тёмно-фиолетовая &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763619548'),
('7404033', '192dc49471eb27449731d3d037dd3825', 'a:14:{s:4:\"cart\";s:937:\"a:1:{s:32:\"b86b2dbd6e770e5d83392492aea62a39\";a:12:{s:3:\"key\";s:32:\"b86b2dbd6e770e5d83392492aea62a39\";s:10:\"product_id\";i:10810;s:12:\"variation_id\";i:0;s:9:\"variation\";a:0:{}s:8:\"quantity\";d:1;s:9:\"data_hash\";s:32:\"b5c1d5ca8bae6d4896cf1807cdf763f0\";s:13:\"line_tax_data\";a:2:{s:8:\"subtotal\";a:0:{}s:5:\"total\";a:0:{}}s:13:\"line_subtotal\";d:1.3;s:17:\"line_subtotal_tax\";i:0;s:10:\"line_total\";d:1.3;s:8:\"line_tax\";i:0;s:3:\"adp\";a:13:{s:12:\"original_key\";N;s:4:\"attr\";N;s:4:\"orig\";a:3:{s:14:\"original_price\";d:1.3;s:26:\"original_price_without_tax\";d:1.3;s:18:\"original_price_tax\";d:0;}s:7:\"history\";a:0:{}s:8:\"discount\";a:0:{}s:9:\"new_price\";d:1.3;s:29:\"free_item_replace_with_coupon\";N;s:29:\"free_item_replace_coupon_name\";N;s:8:\"currency\";a:3:{s:4:\"code\";s:3:\"BYN\";s:6:\"symbol\";s:2:\"Br\";s:4:\"rate\";d:1;}s:13:\"auto_add_hash\";s:0:\"\";s:19:\"free_cart_item_hash\";s:0:\"\";s:23:\"auto_add_cart_item_hash\";s:0:\"\";s:23:\"selected_free_cart_item\";b:0;}}}\";s:11:\"cart_totals\";s:394:\"a:15:{s:8:\"subtotal\";s:3:\"1.3\";s:12:\"subtotal_tax\";i:0;s:14:\"shipping_total\";s:1:\"0\";s:12:\"shipping_tax\";i:0;s:14:\"shipping_taxes\";a:0:{}s:14:\"discount_total\";i:0;s:12:\"discount_tax\";i:0;s:19:\"cart_contents_total\";s:3:\"1.3\";s:17:\"cart_contents_tax\";i:0;s:19:\"cart_contents_taxes\";a:0:{}s:9:\"fee_total\";s:1:\"0\";s:7:\"fee_tax\";i:0;s:9:\"fee_taxes\";a:0:{}s:5:\"total\";s:4:\"1.30\";s:9:\"total_tax\";d:0;}\";s:15:\"applied_coupons\";s:6:\"a:0:{}\";s:22:\"coupon_discount_totals\";s:6:\"a:0:{}\";s:26:\"coupon_discount_tax_totals\";s:6:\"a:0:{}\";s:21:\"removed_cart_contents\";s:6:\"a:0:{}\";s:28:\"adp_rule_tax_exempt_original\";b:0;s:25:\"previous_shipping_methods\";s:91:\"a:1:{i:0;a:3:{i:0;s:14:\"local_pickup:7\";i:1;s:11:\"flat_rate:8\";i:2;s:14:\"local_pickup:6\";}}\";s:23:\"chosen_shipping_methods\";s:32:\"a:1:{i:0;s:14:\"local_pickup:7\";}\";s:22:\"shipping_method_counts\";s:14:\"a:1:{i:0;i:3;}\";s:10:\"wc_notices\";N;s:23:\"adp_rule_tax_exempt_new\";b:0;s:22:\"shipping_for_package_0\";s:1505:\"a:2:{s:12:\"package_hash\";s:40:\"wc_ship_c9eba4b7ccd43dc32b87bc90482e5c3a\";s:5:\"rates\";a:3:{s:14:\"local_pickup:7\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:7\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:7;s:5:\"label\";s:105:\"Белпочта, мин.заказ 15 руб (оплата пересылки при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:54:\"Бусины (12мм) фисташковый &times; 1\";}}s:11:\"flat_rate:8\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:11:\"flat_rate:8\";s:9:\"method_id\";s:9:\"flat_rate\";s:11:\"instance_id\";i:8;s:5:\"label\";s:149:\"Европочта (только заказы от 15 руб (стоимость доставки оплачивается при получении)\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:54:\"Бусины (12мм) фисташковый &times; 1\";}}s:14:\"local_pickup:6\";O:16:\"WC_Shipping_Rate\":2:{s:7:\"\0*\0data\";a:6:{s:2:\"id\";s:14:\"local_pickup:6\";s:9:\"method_id\";s:12:\"local_pickup\";s:11:\"instance_id\";i:6;s:5:\"label\";s:182:\"Самовывоз (г. Гомель, ул. Волгоградская 14 гостиница Динамо, пом. 106) по предварительному согласованию\";s:4:\"cost\";s:4:\"0.00\";s:5:\"taxes\";a:0:{}}s:12:\"\0*\0meta_data\";a:1:{s:12:\"Товары\";s:54:\"Бусины (12мм) фисташковый &times; 1\";}}}}\";s:8:\"customer\";s:716:\"a:27:{s:2:\"id\";s:1:\"0\";s:13:\"date_modified\";s:0:\"\";s:8:\"postcode\";s:0:\"\";s:4:\"city\";s:0:\"\";s:9:\"address_1\";s:0:\"\";s:7:\"address\";s:0:\"\";s:9:\"address_2\";s:0:\"\";s:5:\"state\";s:0:\"\";s:7:\"country\";s:2:\"BY\";s:17:\"shipping_postcode\";s:0:\"\";s:13:\"shipping_city\";s:0:\"\";s:18:\"shipping_address_1\";s:0:\"\";s:16:\"shipping_address\";s:0:\"\";s:18:\"shipping_address_2\";s:0:\"\";s:14:\"shipping_state\";s:0:\"\";s:16:\"shipping_country\";s:2:\"BY\";s:13:\"is_vat_exempt\";s:0:\"\";s:19:\"calculated_shipping\";s:0:\"\";s:10:\"first_name\";s:0:\"\";s:9:\"last_name\";s:0:\"\";s:7:\"company\";s:0:\"\";s:5:\"phone\";s:0:\"\";s:5:\"email\";s:0:\"\";s:19:\"shipping_first_name\";s:0:\"\";s:18:\"shipping_last_name\";s:0:\"\";s:16:\"shipping_company\";s:0:\"\";s:14:\"shipping_phone\";s:0:\"\";}\";}', '1763619753');
